/*
 * Decompiled with CFR 0.152.
 */
package andyr.jtokeniser.test;

import andyr.jtokeniser.WhiteSpaceTokeniser;
import java.util.List;
import junit.framework.TestCase;

public class WhiteSpaceTokeniserTest
extends TestCase {
    String[] tokens1 = new String[]{"the", "cat", "sat", "on", "the", "mat"};
    String[] tokens2 = new String[]{"He", "said,", "\"Shut-up!\""};
    WhiteSpaceTokeniser wst1;
    WhiteSpaceTokeniser wst2;

    protected void setUp() throws Exception {
        super.setUp();
        String test1 = "the cat sat on the mat";
        String test2 = "He said, \"Shut-up!\"";
        this.wst1 = new WhiteSpaceTokeniser(test1);
        this.wst2 = new WhiteSpaceTokeniser(test2);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public WhiteSpaceTokeniserTest(String arg0) {
        super(arg0);
    }

    public void testCountTokens() {
        WhiteSpaceTokeniserTest.assertEquals((int)6, (int)this.wst1.countTokens());
        WhiteSpaceTokeniserTest.assertEquals((int)3, (int)this.wst2.countTokens());
    }

    public void testNumberOfTokens() {
        WhiteSpaceTokeniserTest.assertEquals((int)6, (int)this.wst1.numberOfTokens());
        WhiteSpaceTokeniserTest.assertEquals((int)3, (int)this.wst2.numberOfTokens());
    }

    public void testHasMoreTokens() {
        WhiteSpaceTokeniserTest.assertTrue((boolean)this.wst1.hasMoreTokens());
        WhiteSpaceTokeniserTest.assertTrue((boolean)this.wst2.hasMoreTokens());
    }

    public void testNextToken() {
        WhiteSpaceTokeniserTest.assertEquals((String)"the", (String)this.wst1.nextToken());
        WhiteSpaceTokeniserTest.assertEquals((String)"cat", (String)this.wst1.nextToken());
        WhiteSpaceTokeniserTest.assertEquals((String)"sat", (String)this.wst1.nextToken());
        WhiteSpaceTokeniserTest.assertEquals((String)"on", (String)this.wst1.nextToken());
        WhiteSpaceTokeniserTest.assertEquals((String)"the", (String)this.wst1.nextToken());
        WhiteSpaceTokeniserTest.assertEquals((String)"mat", (String)this.wst1.nextToken());
        WhiteSpaceTokeniserTest.assertEquals((String)"He", (String)this.wst2.nextToken());
        WhiteSpaceTokeniserTest.assertEquals((String)"said,", (String)this.wst2.nextToken());
        WhiteSpaceTokeniserTest.assertEquals((String)"\"Shut-up!\"", (String)this.wst2.nextToken());
    }

    public void testGetTokens() {
        int i;
        List listTokens1 = this.wst1.getTokens();
        List listTokens2 = this.wst2.getTokens();
        WhiteSpaceTokeniserTest.assertEquals((int)this.tokens1.length, (int)listTokens1.size());
        WhiteSpaceTokeniserTest.assertEquals((int)this.tokens2.length, (int)listTokens2.size());
        for (i = 0; i < this.tokens1.length; ++i) {
            WhiteSpaceTokeniserTest.assertEquals((String)this.tokens1[i], (String)((String)listTokens1.get(i)));
        }
        for (i = 0; i < this.tokens2.length; ++i) {
            WhiteSpaceTokeniserTest.assertEquals((String)this.tokens2[i], (String)((String)listTokens2.get(i)));
        }
    }
}

