/*
 * Decompiled with CFR 0.152.
 */
package andyr.jtokeniser.test;

import andyr.jtokeniser.StringTokeniser;
import junit.framework.TestCase;

public class StringTokeniserTest
extends TestCase {
    StringTokeniser st1;
    StringTokeniser st2;
    StringTokeniser st3;
    StringTokeniser st4;

    protected void setUp() throws Exception {
        super.setUp();
        String test1 = "the cat sat on the mat";
        String test2 = "He said, \"Shut-up!\"";
        this.st1 = new StringTokeniser(test1);
        this.st2 = new StringTokeniser(test2, " ,\"!-");
        this.st3 = new StringTokeniser(test2, " ,\"!-", true);
        this.st4 = new StringTokeniser("");
    }

    public void testCountTokens() {
        StringTokeniserTest.assertEquals((int)6, (int)this.st1.countTokens());
        StringTokeniserTest.assertEquals((int)4, (int)this.st2.countTokens());
        StringTokeniserTest.assertEquals((int)11, (int)this.st3.countTokens());
        StringTokeniserTest.assertEquals((int)0, (int)this.st4.countTokens());
    }

    public void testNumberOfTokens() {
        StringTokeniserTest.assertEquals((int)6, (int)this.st1.numberOfTokens());
        StringTokeniserTest.assertEquals((int)4, (int)this.st2.numberOfTokens());
        StringTokeniserTest.assertEquals((int)11, (int)this.st3.numberOfTokens());
        StringTokeniserTest.assertEquals((int)0, (int)this.st4.numberOfTokens());
    }

    public void testHasMoreTokens() {
        StringTokeniserTest.assertTrue((boolean)this.st1.hasMoreTokens());
        StringTokeniserTest.assertTrue((boolean)this.st2.hasMoreTokens());
        StringTokeniserTest.assertTrue((boolean)this.st3.hasMoreTokens());
        StringTokeniserTest.assertFalse((boolean)this.st4.hasMoreTokens());
    }

    public void testNextToken() {
        StringTokeniserTest.assertEquals((String)"the", (String)this.st1.nextToken());
        StringTokeniserTest.assertEquals((String)"cat", (String)this.st1.nextToken());
        StringTokeniserTest.assertEquals((String)"sat", (String)this.st1.nextToken());
        StringTokeniserTest.assertEquals((String)"on", (String)this.st1.nextToken());
        StringTokeniserTest.assertEquals((String)"the", (String)this.st1.nextToken());
        StringTokeniserTest.assertEquals((String)"mat", (String)this.st1.nextToken());
        StringTokeniserTest.assertEquals((String)"He", (String)this.st2.nextToken());
        StringTokeniserTest.assertEquals((String)"said", (String)this.st2.nextToken());
        StringTokeniserTest.assertEquals((String)"Shut", (String)this.st2.nextToken());
        StringTokeniserTest.assertEquals((String)"up", (String)this.st2.nextToken());
        StringTokeniserTest.assertEquals((String)"He", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)" ", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)"said", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)",", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)" ", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)"\"", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)"Shut", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)"-", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)"up", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)"!", (String)this.st3.nextToken());
        StringTokeniserTest.assertEquals((String)"\"", (String)this.st3.nextToken());
    }
}

