/*
 * Decompiled with CFR 0.152.
 */
package andyr.jtokeniser.test;

import andyr.jtokeniser.SentenceTokeniser;
import java.util.Locale;
import junit.framework.TestCase;

public class SentenceTokeniserTest
extends TestCase {
    SentenceTokeniser st1;
    SentenceTokeniser st2;
    SentenceTokeniser st3;
    SentenceTokeniser st4;
    SentenceTokeniser st5;
    SentenceTokeniser st6;
    SentenceTokeniser st7;

    protected void setUp() throws Exception {
        super.setUp();
        String test1 = "Dr Pearson wasn't a physcian. She has a PhD. instead.";
        String test2 = "It was a wonderful surprise! I don't\nknow why.";
        String test3 = "Dr. Pearson wasn't a physcian. She has a PhD. instead.";
        this.st1 = new SentenceTokeniser(test1);
        this.st2 = new SentenceTokeniser(test2);
        this.st3 = new SentenceTokeniser(test1, Locale.getDefault());
        this.st4 = new SentenceTokeniser(test2, Locale.getDefault());
        this.st5 = new SentenceTokeniser(test3);
        this.st6 = new SentenceTokeniser(test3, Locale.getDefault());
        this.st7 = new SentenceTokeniser("");
    }

    public void testCountTokens() {
        SentenceTokeniserTest.assertEquals((int)2, (int)this.st1.countTokens());
        SentenceTokeniserTest.assertEquals((int)2, (int)this.st2.countTokens());
        SentenceTokeniserTest.assertEquals((int)2, (int)this.st3.countTokens());
        SentenceTokeniserTest.assertEquals((int)2, (int)this.st4.countTokens());
        SentenceTokeniserTest.assertEquals((int)3, (int)this.st5.countTokens());
        SentenceTokeniserTest.assertEquals((int)3, (int)this.st6.countTokens());
        SentenceTokeniserTest.assertEquals((int)0, (int)this.st7.countTokens());
    }

    public void testNumberOfTokens() {
        SentenceTokeniserTest.assertEquals((int)2, (int)this.st1.numberOfTokens());
        SentenceTokeniserTest.assertEquals((int)2, (int)this.st2.numberOfTokens());
        SentenceTokeniserTest.assertEquals((int)2, (int)this.st3.numberOfTokens());
        SentenceTokeniserTest.assertEquals((int)2, (int)this.st4.numberOfTokens());
        SentenceTokeniserTest.assertEquals((int)3, (int)this.st5.numberOfTokens());
        SentenceTokeniserTest.assertEquals((int)3, (int)this.st6.numberOfTokens());
        SentenceTokeniserTest.assertEquals((int)0, (int)this.st7.numberOfTokens());
    }

    public void testHasMoreTokens() {
        SentenceTokeniserTest.assertTrue((boolean)this.st1.hasMoreTokens());
        SentenceTokeniserTest.assertTrue((boolean)this.st2.hasMoreTokens());
        SentenceTokeniserTest.assertTrue((boolean)this.st3.hasMoreTokens());
        SentenceTokeniserTest.assertTrue((boolean)this.st4.hasMoreTokens());
        SentenceTokeniserTest.assertTrue((boolean)this.st5.hasMoreTokens());
        SentenceTokeniserTest.assertTrue((boolean)this.st6.hasMoreTokens());
        SentenceTokeniserTest.assertFalse((boolean)this.st7.hasMoreTokens());
    }

    public void testNextToken() {
        SentenceTokeniserTest.assertEquals((String)"Dr Pearson wasn't a physcian.", (String)this.st1.nextToken());
        SentenceTokeniserTest.assertEquals((String)"She has a PhD. instead.", (String)this.st1.nextToken());
        SentenceTokeniserTest.assertEquals((String)"It was a wonderful surprise!", (String)this.st2.nextToken());
        SentenceTokeniserTest.assertEquals((String)"I don't\nknow why.", (String)this.st2.nextToken());
        SentenceTokeniserTest.assertEquals((String)"Dr Pearson wasn't a physcian.", (String)this.st3.nextToken());
        SentenceTokeniserTest.assertEquals((String)"She has a PhD. instead.", (String)this.st3.nextToken());
        SentenceTokeniserTest.assertEquals((String)"It was a wonderful surprise!", (String)this.st4.nextToken());
        SentenceTokeniserTest.assertEquals((String)"I don't\nknow why.", (String)this.st4.nextToken());
        SentenceTokeniserTest.assertEquals((String)"Dr.", (String)this.st5.nextToken());
        SentenceTokeniserTest.assertEquals((String)"Pearson wasn't a physcian.", (String)this.st5.nextToken());
        SentenceTokeniserTest.assertEquals((String)"She has a PhD. instead.", (String)this.st5.nextToken());
        SentenceTokeniserTest.assertEquals((String)"Dr.", (String)this.st6.nextToken());
        SentenceTokeniserTest.assertEquals((String)"Pearson wasn't a physcian.", (String)this.st6.nextToken());
        SentenceTokeniserTest.assertEquals((String)"She has a PhD. instead.", (String)this.st6.nextToken());
    }

    public void testGetTokens() {
    }
}

