/*
 * Decompiled with CFR 0.152.
 */
package andyr.jtokeniser.test;

import andyr.jtokeniser.RegexTokeniser;
import junit.framework.TestCase;

public class RegexTokeniserTest
extends TestCase {
    RegexTokeniser rt1;
    RegexTokeniser rt2;
    RegexTokeniser rt3;
    RegexTokeniser rt4;
    RegexTokeniser rt5;

    protected void setUp() throws Exception {
        super.setUp();
        String test1 = "the cat sat on the mat";
        String test2 = "He said, \"Shut-up!\"";
        String test3 = "123abc456def789";
        this.rt1 = new RegexTokeniser(test1);
        this.rt2 = new RegexTokeniser(test2);
        this.rt3 = new RegexTokeniser(test2, "\\w+");
        this.rt4 = new RegexTokeniser("");
        this.rt5 = new RegexTokeniser(test3, "\\D+", true);
    }

    public void testCountTokens() {
        RegexTokeniserTest.assertEquals((int)6, (int)this.rt1.countTokens());
        RegexTokeniserTest.assertEquals((int)3, (int)this.rt2.countTokens());
        RegexTokeniserTest.assertEquals((int)4, (int)this.rt3.countTokens());
        RegexTokeniserTest.assertEquals((int)0, (int)this.rt4.countTokens());
        RegexTokeniserTest.assertEquals((int)3, (int)this.rt5.countTokens());
    }

    public void testNumberOfTokens() {
        RegexTokeniserTest.assertEquals((int)6, (int)this.rt1.numberOfTokens());
        RegexTokeniserTest.assertEquals((int)3, (int)this.rt2.numberOfTokens());
        RegexTokeniserTest.assertEquals((int)4, (int)this.rt3.numberOfTokens());
        RegexTokeniserTest.assertEquals((int)0, (int)this.rt4.numberOfTokens());
        RegexTokeniserTest.assertEquals((int)3, (int)this.rt5.numberOfTokens());
    }

    public void testHasMoreTokens() {
        RegexTokeniserTest.assertTrue((boolean)this.rt1.hasMoreTokens());
        RegexTokeniserTest.assertTrue((boolean)this.rt2.hasMoreTokens());
        RegexTokeniserTest.assertTrue((boolean)this.rt3.hasMoreTokens());
        RegexTokeniserTest.assertFalse((boolean)this.rt4.hasMoreTokens());
        RegexTokeniserTest.assertTrue((boolean)this.rt5.hasMoreTokens());
    }

    public void testNextToken() {
        RegexTokeniserTest.assertEquals((String)"the", (String)this.rt1.nextToken());
        RegexTokeniserTest.assertEquals((String)"cat", (String)this.rt1.nextToken());
        RegexTokeniserTest.assertEquals((String)"sat", (String)this.rt1.nextToken());
        RegexTokeniserTest.assertEquals((String)"on", (String)this.rt1.nextToken());
        RegexTokeniserTest.assertEquals((String)"the", (String)this.rt1.nextToken());
        RegexTokeniserTest.assertEquals((String)"mat", (String)this.rt1.nextToken());
        RegexTokeniserTest.assertEquals((String)"He", (String)this.rt2.nextToken());
        RegexTokeniserTest.assertEquals((String)"said,", (String)this.rt2.nextToken());
        RegexTokeniserTest.assertEquals((String)"\"Shut-up!\"", (String)this.rt2.nextToken());
        RegexTokeniserTest.assertEquals((String)"He", (String)this.rt3.nextToken());
        RegexTokeniserTest.assertEquals((String)"said", (String)this.rt3.nextToken());
        RegexTokeniserTest.assertEquals((String)"Shut", (String)this.rt3.nextToken());
        RegexTokeniserTest.assertEquals((String)"up", (String)this.rt3.nextToken());
        RegexTokeniserTest.assertEquals((String)"abc", (String)this.rt5.nextToken());
        RegexTokeniserTest.assertEquals((String)"456", (String)this.rt5.nextToken());
        RegexTokeniserTest.assertEquals((String)"def", (String)this.rt5.nextToken());
    }
}

