/*
 * Decompiled with CFR 0.152.
 */
package andyr.jtokeniser.test;

import andyr.jtokeniser.RegexSeparatorTokeniser;
import junit.framework.TestCase;

public class RegexSeparatorTokeniserTest
extends TestCase {
    RegexSeparatorTokeniser rst1;
    RegexSeparatorTokeniser rst2;
    RegexSeparatorTokeniser rst3;
    RegexSeparatorTokeniser rst4;
    RegexSeparatorTokeniser rst5;

    protected void setUp() throws Exception {
        super.setUp();
        String test1 = "the cat sat on the mat";
        String test2 = "He said, \"Shut-up!\"";
        String test3 = "abc123def456ghi";
        this.rst1 = new RegexSeparatorTokeniser(test1);
        this.rst2 = new RegexSeparatorTokeniser(test2);
        this.rst3 = new RegexSeparatorTokeniser(test2, "\\s+|\\p{Punct}+");
        this.rst4 = new RegexSeparatorTokeniser("");
        this.rst5 = new RegexSeparatorTokeniser(test3, "\\d+", true);
    }

    public void testCountTokens() {
        RegexSeparatorTokeniserTest.assertEquals((int)6, (int)this.rst1.countTokens());
        RegexSeparatorTokeniserTest.assertEquals((int)3, (int)this.rst2.countTokens());
        RegexSeparatorTokeniserTest.assertEquals((int)4, (int)this.rst3.countTokens());
        RegexSeparatorTokeniserTest.assertEquals((int)0, (int)this.rst4.countTokens());
        RegexSeparatorTokeniserTest.assertEquals((int)5, (int)this.rst5.countTokens());
    }

    public void testNumberOfTokens() {
        RegexSeparatorTokeniserTest.assertEquals((int)6, (int)this.rst1.numberOfTokens());
        RegexSeparatorTokeniserTest.assertEquals((int)3, (int)this.rst2.numberOfTokens());
        RegexSeparatorTokeniserTest.assertEquals((int)4, (int)this.rst3.numberOfTokens());
        RegexSeparatorTokeniserTest.assertEquals((int)0, (int)this.rst4.numberOfTokens());
        RegexSeparatorTokeniserTest.assertEquals((int)5, (int)this.rst5.countTokens());
    }

    public void testHasMoreTokens() {
        RegexSeparatorTokeniserTest.assertTrue((boolean)this.rst1.hasMoreTokens());
        RegexSeparatorTokeniserTest.assertTrue((boolean)this.rst2.hasMoreTokens());
        RegexSeparatorTokeniserTest.assertTrue((boolean)this.rst3.hasMoreTokens());
        RegexSeparatorTokeniserTest.assertFalse((boolean)this.rst4.hasMoreTokens());
        RegexSeparatorTokeniserTest.assertTrue((boolean)this.rst5.hasMoreTokens());
    }

    public void testNextToken() {
        RegexSeparatorTokeniserTest.assertEquals((String)"the", (String)this.rst1.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"cat", (String)this.rst1.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"sat", (String)this.rst1.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"on", (String)this.rst1.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"the", (String)this.rst1.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"mat", (String)this.rst1.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"He", (String)this.rst2.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"said,", (String)this.rst2.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"\"Shut-up!\"", (String)this.rst2.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"He", (String)this.rst3.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"said", (String)this.rst3.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"Shut", (String)this.rst3.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"up", (String)this.rst3.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"abc", (String)this.rst5.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"123", (String)this.rst5.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"def", (String)this.rst5.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"456", (String)this.rst5.nextToken());
        RegexSeparatorTokeniserTest.assertEquals((String)"ghi", (String)this.rst5.nextToken());
    }
}

