/*
 * Decompiled with CFR 0.152.
 */
package andyr.jtokeniser.test;

import andyr.jtokeniser.BreakIteratorTokeniser;
import java.util.Locale;
import junit.framework.TestCase;

public class BreakIteratorTokeniserTest
extends TestCase {
    BreakIteratorTokeniser bit1;
    BreakIteratorTokeniser bit2;
    BreakIteratorTokeniser bit3;
    BreakIteratorTokeniser bit4;
    BreakIteratorTokeniser bit5;

    protected void setUp() throws Exception {
        super.setUp();
        String test1 = "the cat sat on the mat";
        String test2 = "He said, \"Shut-up!\"";
        this.bit1 = new BreakIteratorTokeniser(test1);
        this.bit2 = new BreakIteratorTokeniser(test2);
        this.bit3 = new BreakIteratorTokeniser(test1, Locale.getDefault());
        this.bit4 = new BreakIteratorTokeniser(test2, Locale.getDefault());
        this.bit5 = new BreakIteratorTokeniser("");
    }

    public void testCountTokens() {
        BreakIteratorTokeniserTest.assertEquals((int)6, (int)this.bit1.countTokens());
        BreakIteratorTokeniserTest.assertEquals((int)3, (int)this.bit2.countTokens());
        BreakIteratorTokeniserTest.assertEquals((int)6, (int)this.bit3.countTokens());
        BreakIteratorTokeniserTest.assertEquals((int)3, (int)this.bit4.countTokens());
        BreakIteratorTokeniserTest.assertEquals((int)0, (int)this.bit5.countTokens());
    }

    public void testNumberOfTokens() {
        BreakIteratorTokeniserTest.assertEquals((int)6, (int)this.bit1.numberOfTokens());
        BreakIteratorTokeniserTest.assertEquals((int)3, (int)this.bit2.numberOfTokens());
        BreakIteratorTokeniserTest.assertEquals((int)6, (int)this.bit3.numberOfTokens());
        BreakIteratorTokeniserTest.assertEquals((int)3, (int)this.bit4.numberOfTokens());
        BreakIteratorTokeniserTest.assertEquals((int)0, (int)this.bit5.numberOfTokens());
    }

    public void testHasMoreTokens() {
        BreakIteratorTokeniserTest.assertTrue((boolean)this.bit1.hasMoreTokens());
        BreakIteratorTokeniserTest.assertTrue((boolean)this.bit2.hasMoreTokens());
        BreakIteratorTokeniserTest.assertTrue((boolean)this.bit3.hasMoreTokens());
        BreakIteratorTokeniserTest.assertTrue((boolean)this.bit4.hasMoreTokens());
        BreakIteratorTokeniserTest.assertFalse((boolean)this.bit5.hasMoreTokens());
    }

    public void testNextToken() {
        BreakIteratorTokeniserTest.assertEquals((String)"the", (String)this.bit1.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"cat", (String)this.bit1.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"sat", (String)this.bit1.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"on", (String)this.bit1.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"the", (String)this.bit1.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"mat", (String)this.bit1.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"He", (String)this.bit2.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"said", (String)this.bit2.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"Shut-up", (String)this.bit2.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"the", (String)this.bit3.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"cat", (String)this.bit3.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"sat", (String)this.bit3.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"on", (String)this.bit3.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"the", (String)this.bit3.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"mat", (String)this.bit3.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"He", (String)this.bit4.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"said", (String)this.bit4.nextToken());
        BreakIteratorTokeniserTest.assertEquals((String)"Shut-up", (String)this.bit4.nextToken());
    }

    public void testGetTokens() {
    }
}

