/*
 * Decompiled with CFR 0.152.
 */
package andyr.jtokeniser.gui;

import andyr.jtokeniser.BreakIteratorTokeniser;
import andyr.jtokeniser.RegexSeparatorTokeniser;
import andyr.jtokeniser.RegexTokeniser;
import andyr.jtokeniser.SentenceTokeniser;
import andyr.jtokeniser.StringTokeniser;
import andyr.jtokeniser.Tokeniser;
import andyr.jtokeniser.WhiteSpaceTokeniser;
import andyr.jtokeniser.gui.AnnotateTokenPanel;
import andyr.jtokeniser.gui.BreakIteratorPanel;
import andyr.jtokeniser.gui.FileDialog;
import andyr.jtokeniser.gui.RegexSeparatorPanel;
import andyr.jtokeniser.gui.RegexTokeniserPanel;
import andyr.jtokeniser.gui.SentencePanel;
import andyr.jtokeniser.gui.StringTokeniserPanel;
import andyr.jtokeniser.gui.WhiteSpacePanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jTokeniser
extends JFrame {
    private BreakIteratorPanel breakIteratorPanel;
    private RegexSeparatorPanel regexSeparatorPanel;
    private RegexTokeniserPanel regexPanel;
    private StringTokeniserPanel stringTokeniserPanel;
    private WhiteSpacePanel whiteSpacePanel;
    private SentencePanel sentencePanel;
    private AnnotateTokenPanel annotateTokenPanel;
    private FileDialog dlgOpenDialog;
    private FileDialog dlgSaveDialog;
    private Map<String, String> fileEncodings;
    private JButton btnOutput;
    private JButton btnSource;
    private JButton btnTokenise;
    private JComboBox cboTokenisers;
    private JLabel lblOutput;
    private JLabel lblSource;
    private JPanel pnlAnnotation;
    private JPanel pnlConfig;
    private JPanel pnlOptions;
    private JPanel pnlOutput;
    private JPanel pnlSource;
    private JPanel pnlTokeniser;
    private JScrollPane scrOutput;
    private JScrollPane scrSource;
    private JSplitPane splitMain;
    private JSplitPane splitTexts;
    private JTextArea txtOutput;
    private JTextArea txtSource;

    public jTokeniser() {
        String nativeLF = UIManager.getSystemLookAndFeelClassName();
        if (nativeLF.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            nativeLF = UIManager.getCrossPlatformLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (InstantiationException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (UnsupportedLookAndFeelException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.breakIteratorPanel = new BreakIteratorPanel();
        this.regexSeparatorPanel = new RegexSeparatorPanel();
        this.regexPanel = new RegexTokeniserPanel();
        this.stringTokeniserPanel = new StringTokeniserPanel();
        this.whiteSpacePanel = new WhiteSpacePanel();
        this.sentencePanel = new SentencePanel();
        this.annotateTokenPanel = new AnnotateTokenPanel();
        this.initComponents();
    }

    private FileDialog getOpenDialog() {
        if (this.dlgOpenDialog == null) {
            this.dlgOpenDialog = new FileDialog((Frame)this, true, 1, this.getAvailableEncodings());
        }
        return this.dlgOpenDialog;
    }

    private FileDialog getSaveDialog() {
        if (this.dlgSaveDialog == null) {
            this.dlgSaveDialog = new FileDialog((Frame)this, false, 2, this.getAvailableEncodings());
        }
        return this.dlgSaveDialog;
    }

    private Map<String, String> getAvailableEncodings() {
        if (this.fileEncodings == null) {
            this.fileEncodings = new HashMap<String, String>();
            this.fileEncodings.put("Big5", "Big5 (Traditional Chinese)");
            this.fileEncodings.put("Big5-HKSCS", "Big5-HKSCS (Traditional Chinese with Hong Kong extensions)");
            this.fileEncodings.put("EUC-JP", "EUC-JP (Japanese)");
            this.fileEncodings.put("EUC-KR", "EUC-KR (Korean)");
            this.fileEncodings.put("GB18030", "GB18030 (Simplified Chinese)");
            this.fileEncodings.put("GBK", "GBK (Simplified Chinese)");
            this.fileEncodings.put("ISCII91", "ISCII91 (Indic scripts)");
            this.fileEncodings.put("ISO-2022-JP", "ISO-2022-JP (Japanese)");
            this.fileEncodings.put("ISO-2022-KR", "ISO-2022-KR (Korean)");
            this.fileEncodings.put("ISO-8859-1", "ISO-8859-1 (Western)");
            this.fileEncodings.put("ISO-8859-13", "ISO-8859-13 (Baltic)");
            this.fileEncodings.put("ISO-8859-15", "ISO-8859-15 (Western)");
            this.fileEncodings.put("ISO-8859-2", "ISO-8859-2 (Central European)");
            this.fileEncodings.put("ISO-8859-3", "ISO-8859-3 (Southern European)");
            this.fileEncodings.put("ISO-8859-4", "ISO-8859-4 (Baltic)");
            this.fileEncodings.put("ISO-8859-5", "ISO-8859-5 (Cyrillic)");
            this.fileEncodings.put("ISO-8859-6", "ISO-8859-6 (Arabic)");
            this.fileEncodings.put("ISO-8859-7", "ISO-8859-7 (Greek)");
            this.fileEncodings.put("ISO-8859-8", "ISO-8859-8 (Hebrew)");
            this.fileEncodings.put("ISO-8859-9", "ISO-8859-9 (Turkish)");
            this.fileEncodings.put("KOI8-R", "KOI8-R (Russian)");
            this.fileEncodings.put("MacArabic", "MacArabic (Arabic)");
            this.fileEncodings.put("MacCentralEurope", "MacCentralEurope (Central European)");
            this.fileEncodings.put("MacCroatian", "MacCroatian (Croatian)");
            this.fileEncodings.put("MacCyrillic", "MacCyrillic (Cyrillic)");
            this.fileEncodings.put("MacGreek", "MacGreek (Greek)");
            this.fileEncodings.put("MacHebrew", "MacHebrew (Hebrew)");
            this.fileEncodings.put("MacIceland", "MacIceland (Iceland)");
            this.fileEncodings.put("MacRoman", "MacRoman (Roman)");
            this.fileEncodings.put("MacRomania", "MacRomania (Romania)");
            this.fileEncodings.put("MacThai", "MacThai (Thai)");
            this.fileEncodings.put("MacTurkish", "MacTurkish (Turkish)");
            this.fileEncodings.put("MacUkraine", "MacUkraine (Ukraine)");
            this.fileEncodings.put("Shift_JIS", "Shift_JIS (Japanese)");
            this.fileEncodings.put("TIS-620", "TIS-620 (Thai)");
            this.fileEncodings.put("US-ASCII", "US-ASCII (ASCII)");
            this.fileEncodings.put("UTF-16", "UTF-16 (Unicode)");
            this.fileEncodings.put("UTF-16BE", "UTF-16BE (Unicode Big-Endian)");
            this.fileEncodings.put("UTF-16LE", "UTF-16LE (Unicode Little-Endian)");
            this.fileEncodings.put("UTF-8", "UTF-8 (Unicode Eight-bit)");
            this.fileEncodings.put("windows-1250", "windows-1250 (Eastern European)");
            this.fileEncodings.put("windows-1251", "windows-1251 (Cyrillic)");
            this.fileEncodings.put("windows-1252", "windows-1252 (Latin-1)");
            this.fileEncodings.put("windows-1253", "windows-1253 (Greek)");
            this.fileEncodings.put("windows-1254", "windows-1254 (Turkish)");
            this.fileEncodings.put("windows-1255", "windows-1255 (Hebrew)");
            this.fileEncodings.put("windows-1256", "windows-1256 (Arabic)");
            this.fileEncodings.put("windows-1257", "windows-1257 (Baltic)");
            this.fileEncodings.put("windows-1258", "windows-1258 (Vietnamese)");
            this.fileEncodings.put("windows-31j", "windows-31j (Japanese)");
            this.fileEncodings.put("x-EUC-CN", "x-EUC-CN (Simplified Chinese)");
            this.fileEncodings.put("x-EUC-JP-LINUX", "x-EUC-JP-LINUX (Japanese)");
            this.fileEncodings.put("x-EUC-TW", "x-EUC-TW (Traditional Chinese)");
            this.fileEncodings.put("x-MS950-HKSCS", "x-MS950-HKSCS (Traditional Chinese with Hong Kong extensions)");
            this.fileEncodings.put("x-mswin-936", "x-mswin-936 (Simplified Chinese)");
            this.fileEncodings.put("x-windows-949", "x-windows-949 (Korean)");
            this.fileEncodings.put("x-windows-950", "x-windows-950 (Traditional Chinese)");
        }
        return this.fileEncodings;
    }

    private void initComponents() {
        this.splitMain = new JSplitPane();
        this.pnlConfig = new JPanel();
        this.pnlTokeniser = new JPanel();
        this.cboTokenisers = new JComboBox();
        this.pnlOptions = new JPanel();
        this.pnlAnnotation = new JPanel();
        this.btnTokenise = new JButton();
        this.splitTexts = new JSplitPane();
        this.pnlSource = new JPanel();
        this.lblSource = new JLabel();
        this.scrSource = new JScrollPane();
        this.txtSource = new JTextArea();
        this.btnSource = new JButton();
        this.pnlOutput = new JPanel();
        this.lblOutput = new JLabel();
        this.scrOutput = new JScrollPane();
        this.txtOutput = new JTextArea();
        this.btnOutput = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("jTokeniser");
        this.splitMain.setDividerLocation(225);
        this.pnlTokeniser.setBorder(BorderFactory.createTitledBorder("Tokeniser"));
        this.cboTokenisers.setModel(new DefaultComboBoxModel<String>(new String[]{"BreakIteratorTokeniser", "RegexTokeniser", "RegexSeparatorTokeniser", "StringTokeniser", "SentenceTokeniser", "WhiteSpaceTokeniser"}));
        this.cboTokenisers.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                jTokeniser.this.cboTokenisersItemStateChanged(evt);
            }
        });
        GroupLayout pnlTokeniserLayout = new GroupLayout(this.pnlTokeniser);
        this.pnlTokeniser.setLayout(pnlTokeniserLayout);
        pnlTokeniserLayout.setHorizontalGroup(pnlTokeniserLayout.createParallelGroup(1).add(pnlTokeniserLayout.createSequentialGroup().addContainerGap().add(this.cboTokenisers, 0, 168, Short.MAX_VALUE).addContainerGap()));
        pnlTokeniserLayout.setVerticalGroup(pnlTokeniserLayout.createParallelGroup(1).add(2, pnlTokeniserLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.cboTokenisers, -2, -1, -2).addContainerGap()));
        this.pnlOptions.setLayout(new CardLayout());
        this.pnlOptions.setBorder(BorderFactory.createTitledBorder("Options"));
        this.pnlOptions.add((Component)this.breakIteratorPanel, "BreakIteratorTokeniser");
        this.pnlOptions.add((Component)this.regexPanel, "RegexTokeniser");
        this.pnlOptions.add((Component)this.regexSeparatorPanel, "RegexSeparatorTokeniser");
        this.pnlOptions.add((Component)this.sentencePanel, "SentenceTokeniser");
        this.pnlOptions.add((Component)this.stringTokeniserPanel, "StringTokeniser");
        this.pnlOptions.add((Component)this.whiteSpacePanel, "WhiteSpaceTokeniser");
        ((CardLayout)this.pnlOptions.getLayout()).first(this.pnlOptions);
        this.pnlAnnotation.setLayout(new BorderLayout());
        this.pnlAnnotation.setBorder(BorderFactory.createTitledBorder("Token annotation"));
        this.pnlAnnotation.add((Component)this.annotateTokenPanel, "Center");
        this.btnTokenise.setText("Tokenise");
        this.btnTokenise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                jTokeniser.this.btnTokeniseActionPerformed(evt);
            }
        });
        GroupLayout pnlConfigLayout = new GroupLayout(this.pnlConfig);
        this.pnlConfig.setLayout(pnlConfigLayout);
        pnlConfigLayout.setHorizontalGroup(pnlConfigLayout.createParallelGroup(1).add(2, pnlConfigLayout.createSequentialGroup().addContainerGap().add(pnlConfigLayout.createParallelGroup(2).add(1, this.pnlOptions, -1, 204, Short.MAX_VALUE).add(1, this.pnlAnnotation, -1, 204, Short.MAX_VALUE).add(1, this.pnlTokeniser, -1, -1, Short.MAX_VALUE).add(this.btnTokenise)).addContainerGap()));
        pnlConfigLayout.setVerticalGroup(pnlConfigLayout.createParallelGroup(1).add(pnlConfigLayout.createSequentialGroup().addContainerGap().add(this.pnlTokeniser, -2, -1, -2).addPreferredGap(0).add(this.pnlOptions, -2, 208, -2).addPreferredGap(0).add(this.pnlAnnotation, -1, 219, Short.MAX_VALUE).addPreferredGap(0).add(this.btnTokenise).addContainerGap()));
        this.splitMain.setLeftComponent(this.pnlConfig);
        this.splitTexts.setBorder(null);
        this.splitTexts.setDividerLocation(300);
        this.splitTexts.setOrientation(0);
        this.lblSource.setText("Source");
        this.lblSource.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
        this.txtSource.setColumns(20);
        this.txtSource.setRows(5);
        this.txtSource.setText("The cat sat on the mat.");
        this.txtSource.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                jTokeniser.this.txtSourceKeyReleased(evt);
            }
        });
        this.scrSource.setViewportView(this.txtSource);
        this.btnSource.setText("Load source");
        this.btnSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                jTokeniser.this.btnSourceActionPerformed(evt);
            }
        });
        GroupLayout pnlSourceLayout = new GroupLayout(this.pnlSource);
        this.pnlSource.setLayout(pnlSourceLayout);
        pnlSourceLayout.setHorizontalGroup(pnlSourceLayout.createParallelGroup(1).add(pnlSourceLayout.createSequentialGroup().add(this.lblSource).addPreferredGap(0, 433, Short.MAX_VALUE).add(this.btnSource)).add(2, this.scrSource, -1, 561, Short.MAX_VALUE));
        pnlSourceLayout.setVerticalGroup(pnlSourceLayout.createParallelGroup(1).add(pnlSourceLayout.createSequentialGroup().add(pnlSourceLayout.createParallelGroup(1).add(this.lblSource).add(this.btnSource)).addPreferredGap(0).add(this.scrSource, -1, 271, Short.MAX_VALUE)));
        this.splitTexts.setTopComponent(this.pnlSource);
        this.lblOutput.setText("Output");
        this.lblOutput.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
        this.txtOutput.setColumns(20);
        this.txtOutput.setEditable(false);
        this.txtOutput.setRows(5);
        this.scrOutput.setViewportView(this.txtOutput);
        this.btnOutput.setText("Save output");
        this.btnOutput.setEnabled(false);
        this.btnOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                jTokeniser.this.btnOutputActionPerformed(evt);
            }
        });
        GroupLayout pnlOutputLayout = new GroupLayout(this.pnlOutput);
        this.pnlOutput.setLayout(pnlOutputLayout);
        pnlOutputLayout.setHorizontalGroup(pnlOutputLayout.createParallelGroup(1).add(pnlOutputLayout.createSequentialGroup().add(this.lblOutput).addPreferredGap(0, 435, Short.MAX_VALUE).add(this.btnOutput)).add(2, this.scrOutput, -1, 561, Short.MAX_VALUE));
        pnlOutputLayout.setVerticalGroup(pnlOutputLayout.createParallelGroup(1).add(pnlOutputLayout.createSequentialGroup().add(pnlOutputLayout.createParallelGroup(3).add(this.lblOutput).add(this.btnOutput)).addPreferredGap(0).add(this.scrOutput, -1, 230, Short.MAX_VALUE)));
        this.splitTexts.setRightComponent(this.pnlOutput);
        this.splitMain.setRightComponent(this.splitTexts);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.splitMain, -1, 792, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(this.splitMain, -1, 566, Short.MAX_VALUE));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 800) / 2, (screenSize.height - 600) / 2, 800, 600);
    }

    private void btnOutputActionPerformed(ActionEvent evt) {
        final FileDialog fd = this.getSaveDialog();
        int returnVal = fd.showDialog();
        if (returnVal == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String selectedEncoding = fd.getSelectedEncoding();
                    try {
                        String linebuffer = "";
                        String buffer = "";
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fd.getFilename()), selectedEncoding));
                        writer.write(jTokeniser.this.txtOutput.getText());
                        writer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void btnSourceActionPerformed(ActionEvent evt) {
        final FileDialog fd = this.getOpenDialog();
        int returnVal = fd.showDialog();
        if (returnVal == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String selectedEncoding = fd.getSelectedEncoding();
                    System.out.println("Encoding: " + selectedEncoding);
                    try {
                        String linebuffer = "";
                        String buffer = "";
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fd.getFilename()), selectedEncoding));
                        while ((linebuffer = reader.readLine()) != null) {
                            buffer = buffer + linebuffer + '\n';
                        }
                        reader.close();
                        jTokeniser.this.txtSource.setText(buffer.trim());
                        jTokeniser.this.txtOutput.setText("");
                        jTokeniser.this.btnOutput.setEnabled(false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void btnTokeniseActionPerformed(ActionEvent evt) {
        String selectedTokeniser = (String)this.cboTokenisers.getSelectedItem();
        Tokeniser tokeniser = selectedTokeniser.equals("BreakIteratorTokeniser") ? new BreakIteratorTokeniser(this.txtSource.getText(), this.breakIteratorPanel.getLocale()) : (selectedTokeniser.equals("RegexSeparatorTokeniser") ? new RegexSeparatorTokeniser(this.txtSource.getText(), this.regexSeparatorPanel.getRegex(), this.regexSeparatorPanel.isKeepDelim()) : (selectedTokeniser.equals("RegexTokeniser") ? new RegexTokeniser(this.txtSource.getText(), this.regexPanel.getRegex(), this.regexPanel.isKeepDelim()) : (selectedTokeniser.equals("SentenceTokeniser") ? new SentenceTokeniser(this.txtSource.getText(), this.sentencePanel.getLocale()) : (selectedTokeniser.equals("StringTokeniser") ? new StringTokeniser(this.txtSource.getText(), this.stringTokeniserPanel.getDelimiter(), this.stringTokeniserPanel.isKeepDelim()) : (selectedTokeniser.equals("WhiteSpaceTokeniser") ? new WhiteSpaceTokeniser(this.txtSource.getText()) : new WhiteSpaceTokeniser(this.txtSource.getText()))))));
        String output = "";
        while (tokeniser.hasMoreTokens()) {
            output = output + this.annotateTokenPanel.getPrefix() + tokeniser.nextToken() + this.annotateTokenPanel.getSuffix();
        }
        this.txtOutput.setText(output);
        if (this.txtOutput.getText().trim().equals("")) {
            this.btnOutput.setEnabled(false);
        } else {
            this.btnOutput.setEnabled(true);
        }
    }

    private void txtSourceKeyReleased(KeyEvent evt) {
        this.updateTokeniseButton();
    }

    private void cboTokenisersItemStateChanged(ItemEvent evt) {
        CardLayout cl = (CardLayout)this.pnlOptions.getLayout();
        cl.show(this.pnlOptions, (String)evt.getItem());
    }

    private void updateTokeniseButton() {
        if (this.txtSource.getText().trim().equals("")) {
            this.btnTokenise.setEnabled(false);
        } else {
            this.btnTokenise.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new jTokeniser().setVisible(true);
            }
        });
    }
}

