/*
 * Decompiled with CFR 0.152.
 */
package andyr.jtokeniser.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDialog
extends JDialog {
    private JFileChooser fc;
    public static final int OPEN = 3;
    public static final int SAVE = 4;
    static final int OK = 0;
    static final int CANCEL = 1;
    static final int ERROR = 2;
    private int returnVal = 2;
    protected int type = 3;
    protected Map<String, String> encodings;
    protected Vector<String> encodingsVector;
    protected String defaultEncoding;
    private JButton btnBrowse;
    private JButton btnCancel;
    private JButton btnOk;
    private JComboBox cboEncodings;
    private JLabel lblEncodings;
    private JLabel lblFilename;
    private JTextField txtFilename;

    public FileDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.encodings = new HashMap<String, String>();
        this.initComponents();
    }

    public FileDialog(Frame parent, boolean modal, int type, Map<String, String> encodings) {
        super(parent, modal);
        this.type = type;
        this.encodings = encodings;
        this.encodingsVector = new Vector<String>(encodings.values());
        this.defaultEncoding = this.defaultEncoding;
        Collections.sort(this.encodingsVector);
        if (type == 3) {
            this.setTitle("Open file");
        } else if (type == 4) {
            this.setTitle("Save file");
        }
        this.initComponents();
        this.txtFilename.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                FileDialog.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                FileDialog.this.updateButtons();
            }

            public void changedUpdate(DocumentEvent e) {
                FileDialog.this.updateButtons();
            }
        });
        this.setupFileChooserDialog();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void setupFileChooserDialog() {
        this.fc = this.type == 3 ? new JFileChooser(){

            public void approveSelection() {
                File f = this.getSelectedFile();
                if (f.exists()) {
                    super.approveSelection();
                } else {
                    JOptionPane.showMessageDialog(this, f + ": does not exist", "File Open Error", 0);
                }
            }
        } : new JFileChooser();
    }

    private String getDefaultEncoding() {
        String defaultEnc = "";
        if (this.encodings.containsKey(Charset.defaultCharset().name())) {
            defaultEnc = this.encodings.get(Charset.defaultCharset().name());
        }
        return defaultEnc;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnVal;
    }

    protected void updateButtons() {
        if (this.txtFilename.getText().trim().equals("")) {
            this.btnOk.setEnabled(false);
        } else {
            this.btnOk.setEnabled(true);
        }
    }

    public String getFilename() {
        return this.txtFilename.getText();
    }

    public String getSelectedEncoding() {
        String displayEncoding = (String)this.cboEncodings.getSelectedItem();
        return displayEncoding.substring(0, displayEncoding.indexOf(" "));
    }

    private void initComponents() {
        this.lblFilename = new JLabel();
        this.lblEncodings = new JLabel();
        this.cboEncodings = new JComboBox();
        this.btnBrowse = new JButton();
        this.txtFilename = new JTextField();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.lblFilename.setText("Filename");
        this.lblEncodings.setText("Encodings");
        this.cboEncodings.setModel(new DefaultComboBoxModel<String>(this.encodingsVector));
        this.cboEncodings.setSelectedItem(this.getDefaultEncoding());
        this.btnBrowse.setText("Browse");
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDialog.this.btnBrowseActionPerformed(evt);
            }
        });
        this.txtFilename.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                FileDialog.this.txtFilenamePropertyChange(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        if (this.type == 3) {
            this.btnOk.setText("Open");
        } else if (this.type == 4) {
            this.btnOk.setText("Save");
        }
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDialog.this.btnOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.lblEncodings).add(this.lblFilename)).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.txtFilename, -1, 253, Short.MAX_VALUE).addPreferredGap(0).add(this.btnBrowse)).add(this.cboEncodings, 0, 326, Short.MAX_VALUE))).add(2, layout.createSequentialGroup().add(this.btnOk).addPreferredGap(0).add(this.btnCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.lblFilename).add(this.btnBrowse).add(this.txtFilename, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.lblEncodings).add(this.cboEncodings, -2, -1, -2)).addPreferredGap(0, 63, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.btnCancel).add(this.btnOk)).addContainerGap()));
        this.pack();
    }

    private void txtFilenamePropertyChange(PropertyChangeEvent evt) {
        this.updateButtons();
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            String oldText = this.txtFilename.getText();
            this.txtFilename.setText(this.fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.returnVal = 1;
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.returnVal = 0;
        this.dispose();
    }
}

