package aconcorde;

public class WordWithPunctuation implements Comparable {

    String leftPunc;
    String word;
    String rightPunc;

    public WordWithPunctuation(String inWord) {
        word = inWord;
    }

    public WordWithPunctuation(String lPunc, String inWord, String rPunc) {

        leftPunc = lPunc;
        word = inWord;
        rightPunc = rPunc;
    }

    public String getLeftPunctuation() {

        return leftPunc;
    }

    public String getWord() {

        return word;
    }
    
    public String getRightPunctuation() {

        return rightPunc;
    }

    public boolean equals(Object obj) {

        if (obj == this) {
            return true;
        }
        else if (!(obj instanceof WordWithPunctuation)) {
            return false;
        }
        else {
            WordWithPunctuation wwp = (WordWithPunctuation) obj;
            return word.equals(wwp.getWord());
        }

    }

    public int compareTo(Object obj) {

        WordWithPunctuation wwp = (WordWithPunctuation) obj;

        return word.compareTo(wwp.getWord());
    }

    public String toString() {

        return leftPunc + word + rightPunc;
    }
}
