package aconcorde;

public class WordIndexWithPunc implements Comparable {

    String leftPunc;
    int index;
    String rightPunc;

    public WordIndexWithPunc(int inIndex) {
        index = inIndex;
    }

    public WordIndexWithPunc(int inIndex, String lPunc, String rPunc) {

        leftPunc = lPunc;
        index = inIndex;
        rightPunc = rPunc;
    }

    public String getLeftPunctuation() {

        return leftPunc;
    }

    public int getIndex() {

        return index;
    }
    
    public String getRightPunctuation() {

        return rightPunc;
    }

    public boolean equals(Object obj) {

        if (obj == this) {
            return true;
        }
        else if (!(obj instanceof WordIndexWithPunc)) {
            return false;
        }
        else {
            WordIndexWithPunc wiwp = (WordIndexWithPunc) obj;
            return index == wiwp.getIndex();
        }

    }

    public int compareTo(Object obj) {

        WordIndexWithPunc wiwp = (WordIndexWithPunc) obj;

        return new Integer(index).compareTo(new Integer(wiwp.getIndex()));
    }

    public String toString() {

        return leftPunc + index + rightPunc;
    }
}
