package aconcorde;

public class WordFreq implements Comparable {

    private String word;
    private int wordCount;

    public WordFreq() {

        word = "";
        wordCount = 0;
    }

    public WordFreq(String inWord) {
        
        setWord(inWord);
        wordCount = 1;
    }

    public WordFreq(String inWord, int count) {
        
        setWord(inWord);
        setWordCount(count);
    }

    public WordFreq(WordFreq wf) {

        setWord(wf.getWord());
        setWordCount(wf.getWordCount());
    }

    public String getWord() {

        return word;
    }

    public int getWordCount() {

        return wordCount;
    }

    public void setWord(String inWord) {

        if (inWord == "" || inWord == null) {
            throw new IllegalArgumentException("Must pass in an actual word!");
        }

        word = inWord;
    }

    public void setWordCount(int count) {

        if (count < 0) {
            throw new IllegalArgumentException("Word count must not be less than 0");
        }

        wordCount = count;
    }

    public void incrementCount() {

        wordCount++;
    }

    public boolean equals(Object obj) {

        if (obj == this) {
            return true;
        }
        else if (!(obj instanceof WordFreq)) {
            return false;
        }
        else {
            WordFreq wf = (WordFreq) obj;
            return word.equals(wf.getWord());
        }
    }

    public int compareTo(Object obj) {

        WordFreq wf = (WordFreq) obj;

        return word.compareTo(wf.getWord());
    }

    public String toString() {

        return word + " (" + wordCount + ")";
    }
        

}
