package aconcorde;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.Font;
import java.awt.event.*;
import java.beans.*;
import java.util.*;

/**
 * Menu component that handles the functionality expected of a standard
 * "Windows" menu for MDI applications.
 */
public class WindowMenu extends JMenu {
    private MDIDesktopPane desktop;
    private JMenuItem cascade; //=new JMenuItem("Cascade");
    private JMenuItem tile; //=new JMenuItem("Tile");

    // Internationalisation and localisation objects    
    private ResourceBundle labels;
    private Locale currentLocale;

	private Font currentFont;

    public WindowMenu(MDIDesktopPane desktop) {
        loadResources();

        this.desktop=desktop;

		        
        cascade = new JMenuItem(labels.getString("windowMenuCascadeItem"));
        tile = new JMenuItem(labels.getString("windowMenuTileItem"));

        setText(labels.getString("windowMenu"));
        cascade.addActionListener(new ActionListener() {
			@Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.cascadeFrames();
            }
        });
        tile.addActionListener(new ActionListener() {
			@Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.tileFrames();
            }
        });
        addMenuListener(new MenuListener() {
			@Override
            public void menuCanceled (MenuEvent e) {}

			@Override
            public void menuDeselected (MenuEvent e) {
                removeAll();
            }

			@Override
            public void menuSelected (MenuEvent e) {
                buildChildMenus();
            }
        });
    }

    private void loadResources() {

        try {
            currentLocale = Locale.getDefault();
            labels = ResourceBundle.getBundle("aconcorde.LabelsBundle", currentLocale);
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace(System.out);
            System.exit(1);
        }
    }

    /* Sets up the children menus depending on the current desktop state */
    private void buildChildMenus() {
        int i;
        ChildMenuItem menu;
        JInternalFrame[] array = desktop.getAllFrames();
		
		currentFont = ((Aconcorde)desktop).getFontSize();

		cascade.setFont(currentFont);
		tile.setFont(currentFont);

        add(cascade);
        add(tile);
        if (array.length > 0) addSeparator();
        cascade.setEnabled(array.length > 0);
        tile.setEnabled(array.length > 0);

        for (i = 0; i < array.length; i++) {
            menu = new ChildMenuItem(array[i]);
            menu.setState(i == 0);
            menu.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent ae) {
                    JInternalFrame frame = ((ChildMenuItem)ae.getSource()).getFrame();
                    frame.moveToFront();
                    try {
                        frame.setSelected(true);
                    } catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.setIcon(array[i].getFrameIcon());
			menu.setFont(currentFont);
            add(menu);
        }
    }

    /* This JCheckBoxMenuItem descendant is used to track the child frame that corresponds
       to a give menu. */
    class ChildMenuItem extends JCheckBoxMenuItem {
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame=frame;
        }

        public JInternalFrame getFrame() {
            return frame;
        }
    }
}
