package aconcorde;

import java.util.*;
import java.text.*;

public class LeftContextRevComparator implements Comparator {

    private List extractWords(String target) {

        BreakIterator wordIterator = BreakIterator.getWordInstance(Locale.getDefault());
        
        List words = new Vector();

        wordIterator.setText(target);
        int start = wordIterator.first();
        int end = wordIterator.next();

        while (end != BreakIterator.DONE) {
	        String word = target.substring(start,end);
	        if (Character.isLetterOrDigit(word.charAt(0))) {
	            //System.out.println(word);
                words.add(word);
	        }
	        start = end;
	        end = wordIterator.next();
        }

        return words;
    }

    private String reverseWords(String input) {

        String rWords = "";
        List words = new Vector();

        words = extractWords(input);

        ListIterator reIt = words.listIterator(words.size());

        while (reIt.hasPrevious()) {

            rWords += reIt.previous();
            if (reIt.hasPrevious()) {
                rWords += " ";
            }
        }

        return rWords;
    }

    public int compare(Object obj1, Object obj2) {

        String leftContext1 = ((ConcordanceItem)obj1).getLeftContext();
        String leftContext2 = ((ConcordanceItem)obj2).getLeftContext();

        leftContext1 = reverseWords(leftContext1);
        leftContext2 = reverseWords(leftContext2);

        return -1*(leftContext1.compareTo(leftContext2));
        
    }
}
