package aconcorde;

public class ConcordanceItem {

    private String word;
    private String leftContext;
    private String rightContext;

    public ConcordanceItem(String left, String w, String right) {

        leftContext = left;
        word = w;
        rightContext = right;
    }

    public ConcordanceItem(ConcordanceItem ci) {

        leftContext = ci.getLeftContext();
        word = ci.getWord();
        rightContext = ci.getRightContext();

    }

    public String getLeftContext() {

        return leftContext;
    }
    
    public String getRightContext() {

        return rightContext;
    }
    
    public String getWord() {

        return word;
    }

    public String toString() {

        return leftContext + " *" + word + "* " + rightContext;
    }
}
