package aconcorde;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class Aconcorde extends MDIDesktopPane {

    private static JFrame frame;
    private Aconcorde acc;
   
    final JFileChooser fc = new JFileChooser();
	private File currentDirectory;
    private File sourceFile;
    private File targetFile;
    private JDialog fontDialog;
    private JSpinner fontSpinner;
    private JTextField sourceFilenameField;
    private JTextField targetFilenameField;
    private JComboBox encodingOptions;
    private JComboBox sourceEncodingOptions;
    private JComboBox targetEncodingOptions;
    private Font menuFont;
    private Font textFont;
    private Font componentFont;

    // Internationalisation and localisation objects    
    private ResourceBundle labels;
    private Locale currentLocale;
    private ComponentOrientation co;
    
    private String[] encOptions = {"ASCII", "Cp420", "Cp1256", "ISO8859_6", "MacArabic", "UTF8", "UTF-16"};
    private String defaultEncoding = "UTF8"; 
    
    private String programName = "aConCorde";
    private String versionNum = "0.4.3";
    private String developer = "Andrew Roberts";

    private Properties programProperties;
    private int propDefaultWindowSize;

    public Aconcorde() {
       
        super(); 

        loadResources();
        co = ComponentOrientation.getOrientation(currentLocale);

        // Set up the default font
        menuFont = new Font("Lucida Sans", Font.BOLD, 12);
        textFont = new Font("Lucida Sans", Font.PLAIN, 12);
        componentFont = new Font("Lucida Sans", Font.BOLD, 12);

		currentDirectory = new File(".");
        addEncodingAccessory();
        
    }

    private void addEncodingAccessory() {

        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.BOTH;
        c.weightx = 1.0;
        c.ipadx = 2;
        c.ipady = 2;

        JPanel saveOptionsPanel = new JPanel(gridbag);

        saveOptionsPanel.setBorder(new CompoundBorder(
                new CompoundBorder(
                    new EmptyBorder(5, 5, 5, 5),
                    new TitledBorder(labels.getString("saveDialogOptions"))),
                new EmptyBorder(5, 5, 5, 5)));
                    

        //JLabel saveTypeLabel = new JLabel(labels.getString("saveDialogSaveType"));
        JLabel saveEncLabel = new JLabel(labels.getString("saveDialogSaveEnc"));
        
        /*String[] options = {labels.getString("saveDialogSaveAligned"),
                            labels.getString("saveDialogSavePlain") };
        */
        //JComboBox saveOptions = new JComboBox(options);
        encodingOptions = new JComboBox(encOptions);
        encodingOptions.setSelectedItem(defaultEncoding);

        /*saveOptionsPanel.add(saveTypeLabel);
        c.gridwidth = GridBagConstraints.REMAINDER;
        gridbag.setConstraints(saveOptions, c);
        saveOptionsPanel.add(saveOptions);*/
        c.gridwidth = 1;
        gridbag.setConstraints(saveEncLabel, c);
        saveOptionsPanel.add(saveEncLabel);
        c.gridwidth = GridBagConstraints.REMAINDER;
        gridbag.setConstraints(encodingOptions, c);
        saveOptionsPanel.add(encodingOptions);

        fc.setAccessory(saveOptionsPanel);

    }

    private static void applyComponentOrientation(Component c, ComponentOrientation o) {

        c.setComponentOrientation(o);

        if (c instanceof JMenu) {
            JMenu menu = (JMenu) c;
            int nComponents = menu.getMenuComponentCount();
            for (int i = 0; i < nComponents; ++i) {
                applyComponentOrientation(menu.getMenuComponent(i), o);
            }
        }
        else if (c instanceof Container) {
            Container container = (Container) c;
            int nComponents = container.getComponentCount();
            for (int i = 0; i < nComponents; ++i) {
                applyComponentOrientation(container.getComponent(i), o);
            }
        }
    }

    private static void applyFontSize(Component c, Font f) {

		

		if (c instanceof ConcordanceGUI) {
			((ConcordanceGUI)c).applyFontSize(c, f);
		}
		else {
			c.setFont(f);
			if (c instanceof WindowMenu) {
				System.out.println(c instanceof JMenu);
				JMenu menu = (JMenu) c;
				int nComponents = menu.getMenuComponentCount();
				System.out.println(nComponents);
				for (int i = 0; i < nComponents; ++i) {
					applyFontSize(menu.getMenuComponent(i), f);
				}
			}
			else if (c instanceof JMenu) {
				JMenu menu = (JMenu) c;
				int nComponents = menu.getMenuComponentCount();
				for (int i = 0; i < nComponents; ++i) {
					applyFontSize(menu.getMenuComponent(i), f);
				}
			}
			
			else if (c instanceof Container) {
				Container container = (Container) c;
				int nComponents = container.getComponentCount();
				for (int i = 0; i < nComponents; ++i) {
					applyFontSize(container.getComponent(i), f);
				}
	        }
		}
    }

    private static void applyCompFontSize(Component c, Font f) {


        if (c instanceof JMenu) {
        }
        else if (c instanceof JMenuItem) {
        }
        else if (c instanceof JLabel) {
            c.setFont(f);
        }
        else if (c instanceof JButton) {
            c.setFont(f);
        }
        else if (c instanceof JTextField) {
            c.setFont(f);
        }
        else if (c instanceof JComboBox) {
            c.setFont(f);
        }
        else if (c instanceof Container) {
            
            Container container = (Container) c;
            int nComponents = container.getComponentCount();
            for (int i = 0; i < nComponents; ++i) {
                applyCompFontSize(container.getComponent(i), f);
            }
        }

    }

	public Font getFontSize() {

		return menuFont;
	}

    private void loadResources() {

        try {

            // Language resources...
            currentLocale = Locale.getDefault();
            labels = ResourceBundle.getBundle("aconcorde.LabelsBundle", currentLocale);

            // Program properties...

            programProperties = new Properties();
			InputStream in = getClass().getResourceAsStream("/aconcorde/Aconcorde.properties");
            programProperties.load(in);
            //programProperties.load(new FileInputStream("Aconcorde.properties"));

            propDefaultWindowSize = Integer.parseInt(programProperties.getProperty("defaultWindowSize", "5"));
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Malformed Unicode in Aconcorde.properties. Ignoring file and using inbuilt defaults instead...");
            iae.printStackTrace(System.err);
            propDefaultWindowSize = 5;
        }
        catch (IOException ioe) {
            System.err.println("Aconcorde.properties file missing. Using inbuilt defaults instead...");
            ioe.printStackTrace(System.err);
            propDefaultWindowSize = 5;
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private JMenuBar createMenus() {

        Font fLucida = new Font("Lucida Sans", Font.BOLD, 10);
        
        // Create the menu bar
        JMenuBar menuBar = new JMenuBar();

        // Create the main menu headers
        JMenu fileMenu = new JMenu(labels.getString("fileMenu"));
        JMenu settingsMenu = new JMenu(labels.getString("settingsMenu"));
        JMenu viewMenu = new JMenu(labels.getString("viewMenu"));
        JMenu helpMenu = new JMenu(labels.getString("helpMenu"));

        // Create the menu items for fileMenu
        JMenuItem openItem = new JMenuItem(labels.getString("fileMenuOpenItem"));
        
        openItem.addActionListener(new ActionListener() { 

            public void actionPerformed(ActionEvent event) {

                createFileOpenDialog();
                
            }
        });
        
        JMenuItem exitItem = new JMenuItem(labels.getString("fileMenuExitItem"));

        exitItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent event) {
                
                shutdown();
            }
        });
        
        fileMenu.add(openItem);
        fileMenu.add(exitItem);

        // Creat the menu items for the settingsMenu
        /*JMenuItem windowItem = new JMenuItem(labels.getString("settingsMenuWindowItem"));

        windowItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                //createWindowSizeDialog();
            }
        });
        
		*/
        JMenuItem fontItem = new JMenuItem(labels.getString("settingsMenuFontItem"));
        //fontItem.setEnabled(false);

        fontItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                createFontSizeDialog();
            }
        });
        // create the language submenu

        JMenu langMenu = new LocaleChanger();
        
        //settingsMenu.add(windowItem);
        settingsMenu.add(fontItem);
        settingsMenu.add(langMenu);

        
        // Create the Windows menu

        
        // Create the menu items for helpMenu
        JMenuItem contentsItem = new JMenuItem(labels.getString("helpMenuContentsItem"));
        contentsItem.setEnabled(false);
        JMenuItem aboutItem = new JMenuItem(labels.getString("helpMenuAboutItem"));
        aboutItem.addActionListener(new ActionListener() {
			@Override
            public void actionPerformed(ActionEvent event) {
                createAboutDialog();
            }
        });
        helpMenu.add(contentsItem);
        helpMenu.add(aboutItem);

        menuBar.add(fileMenu);
        menuBar.add(settingsMenu);
        menuBar.add(new WindowMenu(this));
        menuBar.add(helpMenu);

        return menuBar;
        
    }

    private void createFileOpenDialog() {

		fc.setCurrentDirectory(currentDirectory);
        int returnVal = fc.showOpenDialog(this);

        if (returnVal == JFileChooser.APPROVE_OPTION) {

            // get file name
            File corpus = fc.getSelectedFile();

            if ((String)encodingOptions.getSelectedItem() != null) {
                ConcordanceGUI conc = new ConcordanceGUI(corpus, (String)encodingOptions.getSelectedItem(), propDefaultWindowSize, menuFont, programProperties);
                conc.setSize(800, 600);
                add(conc);
                conc.setVisible(true);
				currentDirectory = corpus;
            }
            
        }

    }

    private void showBrowseFileDialog(int index) {

        int returnVal;
        
		fc.setCurrentDirectory(currentDirectory);

        if (index == 0) {
            encodingOptions.setSelectedIndex(sourceEncodingOptions.getSelectedIndex());
            returnVal = fc.showOpenDialog(this);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                sourceFile = fc.getSelectedFile();
                sourceFilenameField.setText(sourceFile.getName());
                sourceEncodingOptions.setSelectedIndex(encodingOptions.getSelectedIndex());
                currentDirectory = fc.getCurrentDirectory();
            }
        }
        else if (index == 1) {
            encodingOptions.setSelectedIndex(sourceEncodingOptions.getSelectedIndex());
            returnVal = fc.showOpenDialog(this);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                targetFile = fc.getSelectedFile();
                targetFilenameField.setText(targetFile.getName());
                targetEncodingOptions.setSelectedIndex(encodingOptions.getSelectedIndex());
                currentDirectory = fc.getCurrentDirectory();
            }
        }
    }

    private void createFontSizeDialog() {

        fontDialog = new JDialog(frame, labels.getString("fontSizeTitle"), true);

        Container contents = fontDialog.getContentPane();

        contents.setLayout(new BorderLayout());

        JPanel fontSettings = new JPanel();
        JPanel buttonsPanel = new JPanel();
        
        // Create a number spinner that only handles values in the range [0,100]
        int min = 8;
        int max = 72;
        int step = 1;

        fontSpinner = new JSpinner(new SpinnerNumberModel(menuFont.getSize(), min, max, step));
        
        /*menuSpinner = new JSpinner(new SpinnerNumberModel(menuFont.getSize(), min, max, step));
        textSpinner = new JSpinner(new SpinnerNumberModel(textFont.getSize(), min, max, step));
        componentSpinner = new JSpinner(new SpinnerNumberModel(componentFont.getSize(), min, max, step));
        */
        
        fontSettings.setLayout(new GridLayout(1, 2));
        fontSettings.add(new JLabel(labels.getString("fontSize")));
        fontSettings.add(fontSpinner);
        
        JButton fontSizeOk = new JButton(labels.getString("fontSizeOk"));
        fontSizeOk.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {

                int menuSize = ((Integer)fontSpinner.getValue()).intValue();
                int textSize = menuSize;
                int compSize = textSize;
                
                menuFont = new Font(menuFont.getName(), menuFont.getStyle(), menuSize);
                textFont = new Font(textFont.getName(), textFont.getStyle(), textSize);
                componentFont = new Font(componentFont.getName(), componentFont.getStyle(), compSize);
                
				Aconcorde.applyFontSize(frame, menuFont);
               
                fontDialog.setVisible(false);
               

            }
        });

        JButton fontSizeCancel = new JButton(labels.getString("fontSizeCancel"));

        fontSizeCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                fontDialog.setVisible(false);
            }
        });

        buttonsPanel.add(fontSizeOk);
        buttonsPanel.add(fontSizeCancel);
        
        contents.add(fontSettings, BorderLayout.CENTER);
        contents.add(buttonsPanel, BorderLayout.SOUTH);
        fontDialog.setLocationRelativeTo(this);
        fontDialog.pack();
        fontDialog.setVisible(true);
        
    }

    private void createAboutDialog() {

        String message = programName + "\n";
        message += "Version " + versionNum + "\n\n";
        message += labels.getString("aboutDeveloped") + " " + developer + "\n";
        message += "School of Computing\n";
        message += "University of Leeds\n";
        message += "Leeds\n";
        message += "United Kingdom\n\n";
        message += labels.getString("aboutAck") + ":\n";
        message += labels.getString("aboutArabicTranslation") + " - Latifa Al-Sulaiti,\nBayan Abu Shawar &\nSaleh Al-Osaimi";

        JOptionPane.showMessageDialog(
                this, 
                message,
                labels.getString("helpMenuAboutItem"),
                JOptionPane.PLAIN_MESSAGE);                
    }

  /**
   * A class to change the locale for the application
   */
  class LocaleChanger extends JMenu implements ItemListener {

    public LocaleChanger() {
      super();
      setText(labels.getString("settingsMenuLanguageItem"));
      //setFont(menuFont);
      //setMnemonic(resources.getString("LanguageMenuMnemonic").charAt(0));

      ButtonGroup langGroup = new ButtonGroup();
      String language = Locale.getDefault().getLanguage();

      // Sort the language names according to the rules specific to each locale
      RuleBasedCollator rbc = (RuleBasedCollator)Collator.getInstance();
      ArrayList al = new ArrayList();
      al.add(labels.getString("settingsMenuLanguageArabicItem"));
      //al.add(resources.getString("Chinese"));
      al.add(labels.getString("settingsMenuLanguageEnglishItem"));
      //al.add(resources.getString("German"));
      //al.add(resources.getString("Italian"));
      //al.add(resources.getString("French"));
      //al.add(resources.getString("Hebrew"));
      //al.add(resources.getString("Japanese"));
      //al.add(resources.getString("Russian"));

      Collections.sort(al, rbc);

      String langName = Locale.getDefault().getDisplayLanguage();
      for (int i = 0; i < al.size(); i++) {
        JRadioButtonMenuItem mi;
        mi = (JRadioButtonMenuItem)
          add(new JRadioButtonMenuItem((String)al.get(i)));
        //mi.setFont(menuFont);
        if (langName.equalsIgnoreCase((String)al.get(i)))
          mi.setSelected(true);
        mi.addItemListener(this);
        langGroup.add(mi);
      }
    }

    public void itemStateChanged(ItemEvent e) {
      try {      
      JRadioButtonMenuItem rb = (JRadioButtonMenuItem) e.getSource();
      if (rb.isSelected()) {
        String selected = rb.getText();
        if (selected.equals(labels.getString("settingsMenuLanguageArabicItem"))) {
          Locale.setDefault(new Locale("ar", "EG"));
          co = ComponentOrientation.RIGHT_TO_LEFT;
        } else if (selected.equals(labels.getString("settingsMenuLanguageEnglishItem"))) {
          Locale.setDefault(Locale.UK);
          co = ComponentOrientation.LEFT_TO_RIGHT;
        }/* else if (selected.equals(resources.getString("German"))) {
          Locale.setDefault(Locale.GERMANY);
          co = ComponentOrientation.LEFT_TO_RIGHT;
        } else if (selected.equals(resources.getString("Italian"))) {
          Locale.setDefault(Locale.ITALY);
          co = ComponentOrientation.LEFT_TO_RIGHT;
        } else if (selected.equals(resources.getString("French"))) {
          Locale.setDefault(Locale.FRANCE);
          co = ComponentOrientation.LEFT_TO_RIGHT;
        } else if (selected.equals(resources.getString("Hebrew"))) {
          Locale.setDefault(new Locale("iw", "IL"));
          co = ComponentOrientation.RIGHT_TO_LEFT;
        } else if (selected.equals(resources.getString("Chinese"))) {
          Locale.setDefault(Locale.CHINA);
          co = ComponentOrientation.LEFT_TO_RIGHT;
        } else if (selected.equals(resources.getString("Japanese"))) {
          Locale.setDefault(Locale.JAPAN);
          co = ComponentOrientation.LEFT_TO_RIGHT;
        } else if (selected.equals(resources.getString("Russian"))) {
          Locale.setDefault(new Locale("ru", "RU"));
          co = ComponentOrientation.LEFT_TO_RIGHT;
        }*/
      }

      if (co != null) {

        Aconcorde ac = new Aconcorde();
        Aconcorde.frame.getContentPane().removeAll();
        Aconcorde.frame.setJMenuBar(ac.createMenus());
        Aconcorde.frame.setContentPane(ac);
        Aconcorde.applyComponentOrientation(frame, co);
        Aconcorde.frame.repaint();
      }
      }
      catch (Exception ex) {
          ex.printStackTrace(System.out);
      }

    }
  }

  private void createAndShowGUI() {
        //Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        JDialog.setDefaultLookAndFeelDecorated(true);
        
        //Create and set up the window.
        frame = new JFrame(programName + " - " + versionNum);
        
        WindowAdapter windowListener = new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                shutdown();
            }
        };
        
        frame.addWindowListener(windowListener);
        
        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

        //Create and set up the content pane.
        acc = new Aconcorde();
        
        frame.getContentPane().add(acc);
        frame.setJMenuBar(acc.createMenus());
        acc.applyComponentOrientation(frame, co);

        //Display the window.
        frame.pack();
        frame.setSize(1024,768);
        frame.setVisible(true);
    }

  	private void shutdown() {
  		
  		frame.dispose();
  		try {
			programProperties.store(new FileOutputStream("aConCorde.properties"), new Date().toString());
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
  	}

    public static void main(String[] args) {

        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                Aconcorde gui = new Aconcorde();
                gui.createAndShowGUI();
            }
        });

    }
}
