/*
 * Decompiled with CFR 0.152.
 */
package aconcorde;

public class WordFreq
implements Comparable {
    private String word;
    private int wordCount;

    public WordFreq() {
        this.word = "";
        this.wordCount = 0;
    }

    public WordFreq(String inWord) {
        this.setWord(inWord);
        this.wordCount = 1;
    }

    public WordFreq(String inWord, int count) {
        this.setWord(inWord);
        this.setWordCount(count);
    }

    public WordFreq(WordFreq wf) {
        this.setWord(wf.getWord());
        this.setWordCount(wf.getWordCount());
    }

    public String getWord() {
        return this.word;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    public void setWord(String inWord) {
        if (inWord == "" || inWord == null) {
            throw new IllegalArgumentException("Must pass in an actual word!");
        }
        this.word = inWord;
    }

    public void setWordCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Word count must not be less than 0");
        }
        this.wordCount = count;
    }

    public void incrementCount() {
        ++this.wordCount;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WordFreq)) {
            return false;
        }
        WordFreq wf = (WordFreq)obj;
        return this.word.equals(wf.getWord());
    }

    public int compareTo(Object obj) {
        WordFreq wf = (WordFreq)obj;
        return this.word.compareTo(wf.getWord());
    }

    public String toString() {
        return this.word + " (" + this.wordCount + ")";
    }
}

