/*
 * Decompiled with CFR 0.152.
 */
package aconcorde;

import aconcorde.Aconcorde;
import aconcorde.MDIDesktopPane;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class WindowMenu
extends JMenu {
    private MDIDesktopPane desktop;
    private JMenuItem cascade;
    private JMenuItem tile;
    private ResourceBundle labels;
    private Locale currentLocale;
    private Font currentFont;

    public WindowMenu(MDIDesktopPane desktop) {
        this.loadResources();
        this.desktop = desktop;
        this.cascade = new JMenuItem(this.labels.getString("windowMenuCascadeItem"));
        this.tile = new JMenuItem(this.labels.getString("windowMenuTileItem"));
        this.setText(this.labels.getString("windowMenu"));
        this.cascade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.cascadeFrames();
            }
        });
        this.tile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.tileFrames();
            }
        });
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                WindowMenu.this.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent e) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private void loadResources() {
        try {
            this.currentLocale = Locale.getDefault();
            this.labels = ResourceBundle.getBundle("aconcorde.LabelsBundle", this.currentLocale);
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace(System.out);
            System.exit(1);
        }
    }

    private void buildChildMenus() {
        JInternalFrame[] array = this.desktop.getAllFrames();
        this.currentFont = ((Aconcorde)this.desktop).getFontSize();
        this.cascade.setFont(this.currentFont);
        this.tile.setFont(this.currentFont);
        this.add(this.cascade);
        this.add(this.tile);
        if (array.length > 0) {
            this.addSeparator();
        }
        this.cascade.setEnabled(array.length > 0);
        this.tile.setEnabled(array.length > 0);
        for (int i = 0; i < array.length; ++i) {
            ChildMenuItem menu = new ChildMenuItem(array[i]);
            menu.setState(i == 0);
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JInternalFrame frame = ((ChildMenuItem)ae.getSource()).getFrame();
                    frame.moveToFront();
                    try {
                        frame.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.setIcon(array[i].getFrameIcon());
            menu.setFont(this.currentFont);
            this.add(menu);
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

