/*
 * Decompiled with CFR 0.152.
 */
package aconcorde;

import aconcorde.ColumnSorter;
import aconcorde.Concordance;
import aconcorde.ConcordanceItem;
import aconcorde.LeftContextComparator;
import aconcorde.LeftContextRevComparator;
import aconcorde.RightContextComparator;
import aconcorde.RightContextRevComparator;
import aconcorde.SwingWorker;
import aconcorde.WordFreq;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class ConcordanceGUI
extends JInternalFrame {
    static final int ALIGNED = 0;
    static final int PLAIN = 1;
    private Concordance concordance = new Concordance();
    private String currentWord = "";
    private boolean isCorpusLoaded = false;
    private File currentCorpus = null;
    private String[] encOptions = new String[]{"ASCII", "Cp420", "Cp1256", "ISO8859_6", "MacArabic", "UTF8", "UTF-16"};
    private boolean displayAligned = true;
    private JTextField wordField;
    private JEditorPane editor;
    private JPanel statusBar;
    private JPanel statusBarWords;
    private JPanel freq;
    private JLabel statusFileLabel;
    private JLabel statusWinLabel;
    private JButton doConButton;
    private JSplitPane sp;
    private JTable freqData;
    private JComboBox sortContext;
    final JFileChooser fc = new JFileChooser();
    private JDialog fontDialog;
    private JMenuBar concMenus;
    private TitledBorder concBorder;
    private JSpinner fontSpinner;
    private Font menuFont;
    private Font textFont;
    private Font componentFont;
    private ResourceBundle labels;
    private Locale currentLocale;
    private ComponentOrientation co;
    private boolean textLeftToRight;
    private int wordColIndex = 0;
    private int freqColIndex = 1;
    private Comparator sortContextOrder;
    private ProgressMonitor progressMonitor;
    private StringBuffer outputHTML;
    protected Properties programProperties;

    private static void applyComponentOrientation(Component c, ComponentOrientation o) {
        block3: {
            block2: {
                c.setComponentOrientation(o);
                if (!(c instanceof JMenu)) break block2;
                JMenu menu = (JMenu)c;
                int nComponents = menu.getMenuComponentCount();
                for (int i = 0; i < nComponents; ++i) {
                    ConcordanceGUI.applyComponentOrientation(menu.getMenuComponent(i), o);
                }
                break block3;
            }
            if (!(c instanceof Container)) break block3;
            Container container = (Container)c;
            int nComponents = container.getComponentCount();
            for (int i = 0; i < nComponents; ++i) {
                ConcordanceGUI.applyComponentOrientation(container.getComponent(i), o);
            }
        }
    }

    public void applyFontSize(Component c, Font f) {
        block3: {
            block2: {
                this.componentFont = this.textFont = f;
                this.menuFont = this.textFont;
                c.setFont(f);
                if (!(c instanceof JMenu)) break block2;
                JMenu menu = (JMenu)c;
                int nComponents = menu.getMenuComponentCount();
                for (int i = 0; i < nComponents; ++i) {
                    this.applyFontSize(menu.getMenuComponent(i), f);
                }
                break block3;
            }
            if (!(c instanceof Container)) break block3;
            Container container = (Container)c;
            int nComponents = container.getComponentCount();
            for (int i = 0; i < nComponents; ++i) {
                this.applyFontSize(container.getComponent(i), f);
            }
        }
    }

    private static void applyMenuFontSize(Component c, Font f) {
        block3: {
            block4: {
                block2: {
                    if (!(c instanceof JMenu)) break block2;
                    c.setFont(f);
                    JMenu menu = (JMenu)c;
                    int nComponents = menu.getMenuComponentCount();
                    for (int i = 0; i < nComponents; ++i) {
                        ConcordanceGUI.applyMenuFontSize(menu.getMenuComponent(i), f);
                    }
                    break block3;
                }
                if (!(c instanceof JMenuItem)) break block4;
                c.setFont(f);
                break block3;
            }
            if (!(c instanceof Container)) break block3;
            Container container = (Container)c;
            int nComponents = container.getComponentCount();
            for (int i = 0; i < nComponents; ++i) {
                ConcordanceGUI.applyMenuFontSize(container.getComponent(i), f);
            }
        }
    }

    private static void applyCompFontSize(Component c, Font f) {
        if (!(c instanceof JMenuItem)) {
            c.setFont(f);
            if (c instanceof Container) {
                Container container = (Container)c;
                int nComponents = container.getComponentCount();
                for (int i = 0; i < nComponents; ++i) {
                    ConcordanceGUI.applyCompFontSize(container.getComponent(i), f);
                }
            }
        }
    }

    private void loadResources() {
        try {
            this.currentLocale = Locale.getDefault();
            this.labels = ResourceBundle.getBundle("aconcorde.LabelsBundle", this.currentLocale);
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace(System.out);
            System.exit(1);
        }
    }

    public ConcordanceGUI() {
        this.setupGUI();
    }

    public ConcordanceGUI(File inFile, String enc, int winSize, Font currentFont, Properties programProperties) {
        super(inFile.getName(), true, true, true, true);
        this.programProperties = programProperties;
        this.textFont = this.componentFont = currentFont;
        this.menuFont = this.componentFont;
        this.initConcordance(inFile, enc);
        this.concordance.setWindowSize(winSize);
        this.setupGUI();
    }

    public ConcordanceGUI(ConcordanceGUI gui) {
        this.concordance = gui.getConcordanceClass();
        this.currentWord = gui.getCurrentWord();
        this.editor = gui.getEditor();
        this.setupGUI();
    }

    public Concordance getConcordanceClass() {
        return this.concordance;
    }

    public String getCurrentWord() {
        return this.currentWord;
    }

    public JEditorPane getEditor() {
        return this.editor;
    }

    private void setupGUI() {
        this.loadResources();
        this.co = ComponentOrientation.getOrientation(this.currentLocale);
        this.textLeftToRight = this.co.isLeftToRight();
        this.sortContextOrder = new RightContextComparator();
        BorderLayout layout = new BorderLayout();
        JPanel concPanel = new JPanel();
        concPanel.setLayout(layout);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new FlowLayout());
        inputPanel.add(new JLabel(this.labels.getString("labelWord")));
        this.wordField = new JTextField(20);
        inputPanel.add(this.wordField);
        this.doConButton = new JButton(this.labels.getString("buttonGetConcordance"));
        this.doConButton.addActionListener(new DoConcordanceButton());
        inputPanel.add(this.doConButton);
        concPanel.add((Component)inputPanel, "North");
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        this.editor.setFont(this.textFont);
        this.editor.setContentType("text/html");
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BorderLayout());
        JScrollPane editorScrollPane = new JScrollPane(this.editor);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setMinimumSize(new Dimension(10, 10));
        this.concBorder = BorderFactory.createTitledBorder(this.labels.getString("tabConcordance"));
        editorPanel.setBorder(BorderFactory.createCompoundBorder(this.concBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        String[] sortContextOptions = new String[]{this.labels.getString("sortByLeftAsc"), this.labels.getString("sortByLeftDesc"), this.labels.getString("sortByRightAsc"), this.labels.getString("sortByRightDesc")};
        this.sortContext = new JComboBox<String>(sortContextOptions);
        this.sortContext.setSelectedIndex(2);
        this.sortContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                int selectedItem = cb.getSelectedIndex();
                if (selectedItem == 0) {
                    if (ConcordanceGUI.this.textLeftToRight) {
                        ConcordanceGUI.this.sortContextOrder = new LeftContextComparator();
                    } else {
                        ConcordanceGUI.this.sortContextOrder = new RightContextComparator();
                    }
                } else if (selectedItem == 1) {
                    if (ConcordanceGUI.this.textLeftToRight) {
                        ConcordanceGUI.this.sortContextOrder = new LeftContextRevComparator();
                    } else {
                        ConcordanceGUI.this.sortContextOrder = new RightContextRevComparator();
                    }
                } else if (selectedItem == 2) {
                    if (ConcordanceGUI.this.textLeftToRight) {
                        ConcordanceGUI.this.sortContextOrder = new RightContextComparator();
                    } else {
                        ConcordanceGUI.this.sortContextOrder = new LeftContextComparator();
                    }
                } else if (ConcordanceGUI.this.textLeftToRight) {
                    ConcordanceGUI.this.sortContextOrder = new RightContextRevComparator();
                } else {
                    ConcordanceGUI.this.sortContextOrder = new LeftContextRevComparator();
                }
                ConcordanceGUI.this.getConcordance();
            }
        });
        editorPanel.add((Component)this.sortContext, "North");
        editorPanel.add((Component)editorScrollPane, "Center");
        concPanel.add((Component)editorPanel, "Center");
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new GridLayout(1, 2));
        this.statusFileLabel = new JLabel("");
        this.statusWinLabel = new JLabel("");
        this.statusWinLabel.setText(this.labels.getString("statusbarContextSize") + " " + this.concordance.getWindowSize());
        this.statusFileLabel.setText(this.labels.getString("statusbarFile") + " " + this.currentCorpus.getName() + " (" + this.concordance.getEncoding() + ")");
        this.statusFileLabel.setBorder(new BevelBorder(1));
        this.statusWinLabel.setBorder(new BevelBorder(1));
        this.statusFileLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() >= 2) {
                    ConcordanceGUI.this.createFileOpenDialog();
                }
            }
        });
        this.statusWinLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() >= 2) {
                    ConcordanceGUI.this.createWindowSizeDialog();
                }
            }
        });
        this.statusBar.add(this.statusFileLabel);
        this.statusBar.add(this.statusWinLabel);
        concPanel.add((Component)this.statusBar, "South");
        this.sp = this.co.isLeftToRight() ? new JSplitPane(1, this.freq, concPanel) : new JSplitPane(1, concPanel, this.freq);
        this.freq = new JPanel();
        this.freq = this.createFrequencyPanel();
        if (this.co.isLeftToRight()) {
            this.sp.setLeftComponent(this.freq);
        } else {
            this.sp.setRightComponent(this.freq);
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(this.sp);
        this.setJMenuBar(this.createMenuBar());
        ConcordanceGUI.applyComponentOrientation(this, this.co);
        this.applyFontSize(this, this.menuFont);
    }

    private JMenuBar createMenuBar() {
        this.concMenus = new JMenuBar();
        JMenu fileMenu = new JMenu(this.labels.getString("fileMenu"));
        JMenuItem fileSaveItem = new JMenuItem(this.labels.getString("fileMenuSaveItem"));
        fileSaveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConcordanceGUI.this.createFileSaveDialog();
            }
        });
        JMenuItem fileSaveFreqListItem = new JMenuItem(this.labels.getString("fileMenuSaveFreqListItem"));
        fileSaveFreqListItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConcordanceGUI.this.createFileSaveFreqListDialog();
            }
        });
        JMenuItem fileCloseItem = new JMenuItem(this.labels.getString("fileMenuCloseItem"));
        fileCloseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConcordanceGUI.this.dispose();
            }
        });
        JMenuItem filePrintItem = new JMenuItem(this.labels.getString("fileMenuPrintItem"));
        filePrintItem.setEnabled(false);
        JMenuItem fileCorpusPropItem = new JMenuItem(this.labels.getString("fileMenuPropItem"));
        fileCorpusPropItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConcordanceGUI.this.createCorpusPropDialog();
            }
        });
        fileMenu.add(fileSaveItem);
        fileMenu.add(fileSaveFreqListItem);
        fileMenu.add(fileCloseItem);
        fileMenu.add(filePrintItem);
        fileMenu.add(fileCorpusPropItem);
        JMenu editMenu = new JMenu(this.labels.getString("editMenu"));
        JMenuItem editCopyItem = new JMenuItem(this.labels.getString("editMenuCopyItem"));
        editCopyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConcordanceGUI.this.editor.copy();
            }
        });
        JMenuItem editSelectAllItem = new JMenuItem(this.labels.getString("editMenuSelectAllItem"));
        editSelectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConcordanceGUI.this.editor.requestFocus();
                ConcordanceGUI.this.editor.selectAll();
            }
        });
        editMenu.add(editCopyItem);
        editMenu.add(editSelectAllItem);
        JMenu viewMenu = new JMenu(this.labels.getString("viewMenu"));
        JMenu viewDisplayMenu = new JMenu(this.labels.getString("viewDisplayMenu"));
        ButtonGroup viewDisplayItems = new ButtonGroup();
        JRadioButtonMenuItem viewDisplayAlignedItem = new JRadioButtonMenuItem(this.labels.getString("viewDisplayAlignedItem"), true);
        viewDisplayAlignedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!ConcordanceGUI.this.displayAligned) {
                    ConcordanceGUI.this.displayAligned = true;
                    ConcordanceGUI.this.getConcordance();
                }
            }
        });
        JRadioButtonMenuItem viewDisplayTextItem = new JRadioButtonMenuItem(this.labels.getString("viewDisplayTextItem"));
        viewDisplayTextItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ConcordanceGUI.this.displayAligned) {
                    ConcordanceGUI.this.displayAligned = false;
                    ConcordanceGUI.this.getConcordance();
                }
            }
        });
        viewDisplayItems.add(viewDisplayAlignedItem);
        viewDisplayItems.add(viewDisplayTextItem);
        viewDisplayMenu.add(viewDisplayAlignedItem);
        viewDisplayMenu.add(viewDisplayTextItem);
        JMenu viewOrientationMenu = new JMenu(this.labels.getString("viewOrientationMenu"));
        ButtonGroup viewOrientationItems = new ButtonGroup();
        JRadioButtonMenuItem viewOrientationLTR = new JRadioButtonMenuItem(this.labels.getString("viewOrientationLTRItem"), this.co.isLeftToRight());
        viewOrientationLTR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!ConcordanceGUI.this.textLeftToRight) {
                    ConcordanceGUI.this.textLeftToRight = true;
                    ConcordanceGUI.this.getConcordance();
                }
            }
        });
        JRadioButtonMenuItem viewOrientationRTL = new JRadioButtonMenuItem(this.labels.getString("viewOrientationRTLItem"), !this.co.isLeftToRight());
        viewOrientationRTL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ConcordanceGUI.this.textLeftToRight) {
                    ConcordanceGUI.this.textLeftToRight = false;
                    ConcordanceGUI.this.getConcordance();
                }
            }
        });
        viewOrientationItems.add(viewOrientationLTR);
        viewOrientationItems.add(viewOrientationRTL);
        viewOrientationMenu.add(viewOrientationLTR);
        viewOrientationMenu.add(viewOrientationRTL);
        viewMenu.add(viewDisplayMenu);
        viewMenu.add(viewOrientationMenu);
        this.concMenus.add(fileMenu);
        this.concMenus.add(editMenu);
        this.concMenus.add(viewMenu);
        return this.concMenus;
    }

    private JPanel createFrequencyPanel() {
        JPanel freqPanel = new JPanel();
        this.freqData = new JTable(this.concordance.getWordListSize(), 2){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (rowIndex % 2 == 0 && !this.isCellSelected(rowIndex, vColIndex)) {
                    c.setBackground(new Color(239, 249, 255));
                } else {
                    c.setBackground(this.getBackground());
                }
                return c;
            }
        };
        this.freqData.getColumnModel().getColumn(this.wordColIndex).setHeaderValue(this.labels.getString("columnWord"));
        this.freqData.getColumnModel().getColumn(this.freqColIndex).setHeaderValue(this.labels.getString("columnFreq"));
        ListSelectionModel rowSM = this.freqData.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    ConcordanceGUI.this.currentWord = (String)ConcordanceGUI.this.freqData.getValueAt(selectedRow, ConcordanceGUI.this.wordColIndex);
                    ConcordanceGUI.this.getConcordance();
                }
            }
        });
        this.freqData.setSelectionMode(0);
        this.freqData.setAutoCreateColumnsFromModel(false);
        boolean wordCount = false;
        ListIterator wordListIt = this.concordance.getWordListIterator();
        for (int i = 0; i < this.freqData.getRowCount(); ++i) {
            WordFreq wf = (WordFreq)wordListIt.next();
            this.freqData.setValueAt(wf.getWord(), i, this.wordColIndex);
            this.freqData.setValueAt(new Integer(wf.getWordCount()), i, this.freqColIndex);
        }
        freqPanel.setLayout(new BorderLayout());
        String[] sortOptions = new String[]{this.labels.getString("sortByWordAsc"), this.labels.getString("sortByWordDesc"), this.labels.getString("sortByFreqAsc"), this.labels.getString("sortByFreqDesc")};
        JComboBox<String> sort = new JComboBox<String>(sortOptions);
        sort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                int selectedItem = cb.getSelectedIndex();
                if (selectedItem == 0) {
                    ConcordanceGUI.this.sortAllRowsBy((DefaultTableModel)ConcordanceGUI.this.freqData.getModel(), ConcordanceGUI.this.wordColIndex, true);
                } else if (selectedItem == 1) {
                    ConcordanceGUI.this.sortAllRowsBy((DefaultTableModel)ConcordanceGUI.this.freqData.getModel(), ConcordanceGUI.this.wordColIndex, false);
                } else if (selectedItem == 2) {
                    ConcordanceGUI.this.sortAllRowsBy((DefaultTableModel)ConcordanceGUI.this.freqData.getModel(), ConcordanceGUI.this.freqColIndex, true);
                } else {
                    ConcordanceGUI.this.sortAllRowsBy((DefaultTableModel)ConcordanceGUI.this.freqData.getModel(), ConcordanceGUI.this.freqColIndex, false);
                }
            }
        });
        boolean toggle = false;
        boolean extend = false;
        this.freqData.setColumnSelectionAllowed(true);
        this.freqData.setRowSelectionAllowed(true);
        this.freqData.changeSelection(0, 0, toggle, extend);
        this.currentWord = (String)this.freqData.getValueAt(0, 0);
        this.getConcordance();
        freqPanel.add(sort, "North");
        freqPanel.add((Component)new JScrollPane(this.freqData, 20, 30), "Center");
        this.statusBarWords = new JPanel();
        this.statusBarWords.setLayout(new GridLayout(1, 2));
        JLabel statusWordsUniqueLabel = new JLabel(this.labels.getString("statusbarUniqueWords") + " " + this.freqData.getRowCount());
        JLabel statusWordsTotalLabel = new JLabel(this.labels.getString("statusbarTotalWords") + " " + this.concordance.getWordIndexSize());
        statusWordsUniqueLabel.setBorder(new BevelBorder(1));
        statusWordsTotalLabel.setBorder(new BevelBorder(1));
        this.statusBarWords.add(statusWordsUniqueLabel);
        this.statusBarWords.add(statusWordsTotalLabel);
        freqPanel.add((Component)this.statusBarWords, "South");
        return freqPanel;
    }

    public void sortAllRowsBy(DefaultTableModel model, int colIndex, boolean ascending) {
        Vector<Vector> data = model.getDataVector();
        Collections.sort(data, new ColumnSorter(colIndex, ascending));
        model.fireTableStructureChanged();
    }

    private String savePlainConcordanceText() {
        Vector items = new Vector(this.concordance.concordanceToList(this.currentWord));
        Iterator i = items.iterator();
        String output = "";
        while (i.hasNext()) {
            output = output + i.next() + "\n";
        }
        return output;
    }

    private void getHTMLConcordanceText() {
        Vector items = new Vector(this.concordance.concordanceToList(this.currentWord));
        Iterator i = items.iterator();
        String concFont = this.programProperties.getProperty("concordanceFont", "");
        String fontFamily = "sans-serif";
        if (!concFont.equals("")) {
            fontFamily = "" + concFont + ", sans-serif";
        }
        String csscode = "BODY { font-family: " + fontFamily + "; font-size: " + this.textFont.getSize() + "; }";
        csscode = csscode + "P {text-align: ";
        csscode = this.textLeftToRight ? csscode + "left" : csscode + "right";
        csscode = csscode + "; padding-top: 0; margin-top: 0;}";
        String htmlStart = "<HTML><HEAD><STYLE>" + csscode + "</STYLE></HEAD><BODY><P>";
        String htmlEnd = "</BODY></HTML>";
        this.outputHTML = new StringBuffer(htmlStart);
        while (i.hasNext()) {
            this.outputHTML.append(i.next() + "<br>\n");
        }
        this.outputHTML.append(htmlEnd);
        this.editor.setText(this.outputHTML.toString());
        this.outputHTML = null;
    }

    private String saveHTMLConcordanceTable() {
        Vector items = new Vector(this.concordance.concordanceToList(this.currentWord));
        Collections.sort(items, this.sortContextOrder);
        Iterator i = items.iterator();
        String concFont = this.programProperties.getProperty("concordanceFont", "");
        String fontFamily = "sans-serif";
        if (!concFont.equals("")) {
            fontFamily = "" + concFont + ", sans-serif";
        }
        String csscode = "BODY { font-family: " + fontFamily + "; font-size: " + this.textFont.getSize() + "}";
        csscode = csscode + "P {text-align: ";
        csscode = this.textLeftToRight ? csscode + "left" : csscode + "right";
        csscode = csscode + "right; padding-top: 0; margin-top: 0;}";
        csscode = csscode + ".leftContext { text-align: left;}";
        csscode = csscode + ".rightContext { text-align: right;}";
        csscode = csscode + ".word { color: blue;}";
        String htmlStart = "<HTML>\n<HEAD>\n<STYLE>" + csscode + "</STYLE>\n</HEAD>\n<BODY>\n<P>";
        String htmlEnd = "</BODY>\n</HTML>";
        this.outputHTML = new StringBuffer(htmlStart);
        this.outputHTML.append("<TABLE align=\"center\">\n");
        while (i.hasNext()) {
            ConcordanceItem c = new ConcordanceItem((ConcordanceItem)i.next());
            this.outputHTML.append("<TR>\n");
            if (this.textLeftToRight) {
                this.outputHTML.append("<TD align=\"right\">").append(c.getLeftContext()).append("</TD>\n");
            } else {
                this.outputHTML.append("<TD align=\"right\">").append(c.getRightContext()).append("</TD>\n");
            }
            this.outputHTML.append("<TD class=\"word\">").append(c.getWord()).append("</TD>\n");
            if (this.textLeftToRight) {
                this.outputHTML.append("<TD align=\"left\">").append(c.getRightContext()).append("</TD>\n");
            } else {
                this.outputHTML.append("<TD align=\"left\">").append(c.getLeftContext()).append("</TD>\n");
            }
            this.outputHTML.append("</TR>\n");
        }
        this.outputHTML.append("</TABLE>\n");
        this.outputHTML.append(htmlEnd);
        return this.outputHTML.toString();
    }

    private void getHTMLConcordanceTable() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                Vector items = new Vector(ConcordanceGUI.this.concordance.concordanceToList(ConcordanceGUI.this.currentWord));
                Collections.sort(items, ConcordanceGUI.this.sortContextOrder);
                ConcordanceGUI.this.progressMonitor = new ProgressMonitor(ConcordanceGUI.this, "Getting concordance", "", 0, items.size());
                ConcordanceGUI.this.progressMonitor.setMillisToDecideToPopup(1000);
                ConcordanceGUI.this.progressMonitor.setProgress(0);
                Iterator i = items.iterator();
                String concFont = ConcordanceGUI.this.programProperties.getProperty("concordanceFont", "");
                String fontFamily = "sans-serif";
                if (!concFont.equals("")) {
                    fontFamily = "" + concFont + ", sans-serif";
                }
                String csscode = "BODY { font-family: \"" + fontFamily + "\";font-size: " + ConcordanceGUI.this.textFont.getSize() + "}";
                csscode = csscode + "P {text-align: ";
                csscode = ConcordanceGUI.this.textLeftToRight ? csscode + "left" : csscode + "right";
                csscode = csscode + "right; padding-top: 0; margin-top: 0;}";
                csscode = csscode + ".leftContext { text-align: left;}";
                csscode = csscode + ".rightContext { text-align: right;}";
                csscode = csscode + ".word { color: blue;}";
                String htmlStart = "<HTML>\n<HEAD>\n<STYLE>" + csscode + "</STYLE>\n</HEAD>\n<BODY>\n<P>";
                String htmlEnd = "</BODY>\n</HTML>";
                ConcordanceGUI.this.outputHTML = new StringBuffer(htmlStart);
                ConcordanceGUI.this.outputHTML.append("<TABLE align=\"center\">\n");
                int currentItem = 1;
                while (i.hasNext() && !ConcordanceGUI.this.progressMonitor.isCanceled()) {
                    ConcordanceItem c = new ConcordanceItem((ConcordanceItem)i.next());
                    ConcordanceGUI.this.outputHTML.append("<TR>\n");
                    if (ConcordanceGUI.this.textLeftToRight) {
                        ConcordanceGUI.this.outputHTML.append("<TD align=\"right\">").append(c.getLeftContext()).append("</TD>\n");
                    } else {
                        ConcordanceGUI.this.outputHTML.append("<TD align=\"right\">").append(c.getRightContext()).append("</TD>\n");
                    }
                    ConcordanceGUI.this.outputHTML.append("<TD class=\"word\">").append(c.getWord()).append("</TD>\n");
                    if (ConcordanceGUI.this.textLeftToRight) {
                        ConcordanceGUI.this.outputHTML.append("<TD align=\"left\">").append(c.getRightContext()).append("</TD>\n");
                    } else {
                        ConcordanceGUI.this.outputHTML.append("<TD align=\"left\">").append(c.getLeftContext()).append("</TD>\n");
                    }
                    ConcordanceGUI.this.outputHTML.append("</TR>\n");
                    ConcordanceGUI.this.progressMonitor.setProgress(currentItem);
                    ++currentItem;
                }
                ConcordanceGUI.this.outputHTML.append("</TABLE>\n");
                if (ConcordanceGUI.this.progressMonitor.isCanceled()) {
                    ConcordanceGUI.this.outputHTML.append("<B>Concordance canceled...</B>");
                }
                ConcordanceGUI.this.outputHTML.append(htmlEnd);
                ConcordanceGUI.this.progressMonitor.close();
                return "";
            }

            @Override
            public void finished() {
                ConcordanceGUI.this.editor.setText(ConcordanceGUI.this.outputHTML.toString());
            }
        };
        worker.start();
    }

    private void getConcordance() {
        if (this.displayAligned) {
            this.getHTMLConcordanceTable();
        } else {
            this.getHTMLConcordanceText();
        }
    }

    private String savePlainWordFrequencyText() {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.freqData.getModel().getRowCount(); ++i) {
            output.append(this.freqData.getModel().getValueAt(i, 0)).append(", ").append(this.freqData.getModel().getValueAt(i, 1)).append("\n");
        }
        return output.toString();
    }

    private String saveHtmlWordFrequencyTable(String outEncoding) {
        StringBuilder output = new StringBuilder();
        String csscode = "";
        output.append("<HTML>\n<HEAD><TITLE>" + this.currentCorpus.getName() + "</TITLE>\n<meta charset='" + outEncoding.toLowerCase() + "'>\n<STYLE>").append(csscode).append("</STYLE>\n</HEAD>\n<BODY>\n<TABLE>");
        for (int i = 0; i < this.freqData.getModel().getRowCount(); ++i) {
            output.append("<TR>");
            output.append("<TD>").append(this.freqData.getModel().getValueAt(i, 0)).append("</TD><TD>").append(this.freqData.getModel().getValueAt(i, 1)).append("</TD>\n");
            output.append("</TR>");
        }
        output.append("</TABLE></BODY>\n</HTML>");
        return output.toString();
    }

    private void createFileOpenDialog() {
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = this.fc.getSelectedFile();
            this.wordField.setText("");
            this.isCorpusLoaded = true;
            this.freq = new JPanel();
            this.freq = this.createFrequencyPanel();
            if (this.co.isLeftToRight()) {
                this.sp.setLeftComponent(this.freq);
            } else {
                this.sp.setRightComponent(this.freq);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createFileSaveDialog() {
        JFileChooser save = new JFileChooser();
        save.setDialogType(1);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.ipadx = 2;
        c.ipady = 2;
        JPanel saveOptionsPanel = new JPanel(gridbag);
        saveOptionsPanel.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new TitledBorder(this.labels.getString("saveDialogOptions"))), new EmptyBorder(5, 5, 5, 5)));
        JLabel saveTypeLabel = new JLabel(this.labels.getString("saveDialogSaveType"));
        JLabel saveEncLabel = new JLabel(this.labels.getString("saveDialogSaveEnc"));
        String[] options = new String[]{this.labels.getString("saveDialogSaveAligned"), this.labels.getString("saveDialogSavePlain")};
        JComboBox<String> saveOptions = new JComboBox<String>(options);
        JComboBox<String> encodingOptions = new JComboBox<String>(this.encOptions);
        saveOptionsPanel.add(saveTypeLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(saveOptions, c);
        saveOptionsPanel.add(saveOptions);
        c.gridwidth = 1;
        gridbag.setConstraints(saveEncLabel, c);
        saveOptionsPanel.add(saveEncLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(encodingOptions, c);
        saveOptionsPanel.add(encodingOptions);
        save.setAccessory(saveOptionsPanel);
        if (save.showDialog(this, this.labels.getString("saveDialogTitle")) != 0) {
            save.remove(saveOptionsPanel);
            return;
        }
        File saveFile = save.getSelectedFile();
        try {
            if (!saveFile.exists()) {
                this.saveConcordance(saveFile, (String)encodingOptions.getSelectedItem(), saveOptions.getSelectedIndex());
                return;
            }
            if (saveFile.isDirectory()) {
                JOptionPane.showMessageDialog(this, this.labels.getString("saveDialogDirectoryError"), this.labels.getString("saveDialogErrorTitle"), 0);
                return;
            }
            int userChoice = JOptionPane.showConfirmDialog(this, this.labels.getString("saveDialogOverwriteConfirm"), this.labels.getString("saveDialogOverwriteTitle"), 0);
            if (userChoice == 0) {
                this.saveConcordance(saveFile, (String)encodingOptions.getSelectedItem(), saveOptions.getSelectedIndex());
                return;
            }
            if (userChoice != 1) return;
            return;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createFileSaveFreqListDialog() {
        JFileChooser save = new JFileChooser();
        save.setDialogType(1);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.ipadx = 2;
        c.ipady = 2;
        JPanel saveOptionsPanel = new JPanel(gridbag);
        saveOptionsPanel.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new TitledBorder(this.labels.getString("saveDialogOptions"))), new EmptyBorder(5, 5, 5, 5)));
        JLabel saveTypeLabel = new JLabel(this.labels.getString("saveDialogSaveType"));
        JLabel saveEncLabel = new JLabel(this.labels.getString("saveDialogSaveEnc"));
        String[] options = new String[]{this.labels.getString("saveDialogSaveAligned"), this.labels.getString("saveDialogSavePlain")};
        JComboBox<String> saveOptions = new JComboBox<String>(options);
        JComboBox<String> encodingOptions = new JComboBox<String>(this.encOptions);
        saveOptionsPanel.add(saveTypeLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(saveOptions, c);
        saveOptionsPanel.add(saveOptions);
        c.gridwidth = 1;
        gridbag.setConstraints(saveEncLabel, c);
        saveOptionsPanel.add(saveEncLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(encodingOptions, c);
        saveOptionsPanel.add(encodingOptions);
        save.setAccessory(saveOptionsPanel);
        if (save.showDialog(this, this.labels.getString("saveDialogTitle")) != 0) {
            save.remove(saveOptionsPanel);
            return;
        }
        File saveFile = save.getSelectedFile();
        try {
            if (!saveFile.exists()) {
                this.saveFrequencyList(saveFile, (String)encodingOptions.getSelectedItem(), saveOptions.getSelectedIndex());
                return;
            }
            if (saveFile.isDirectory()) {
                JOptionPane.showMessageDialog(this, this.labels.getString("saveDialogDirectoryError"), this.labels.getString("saveDialogErrorTitle"), 0);
                return;
            }
            int userChoice = JOptionPane.showConfirmDialog(this, this.labels.getString("saveDialogOverwriteConfirm"), this.labels.getString("saveDialogOverwriteTitle"), 0);
            if (userChoice == 0) {
                this.saveFrequencyList(saveFile, (String)encodingOptions.getSelectedItem(), saveOptions.getSelectedIndex());
                return;
            }
            if (userChoice != 1) return;
            return;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    private void createCorpusPropDialog() {
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMinimumIntegerDigits(1);
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(2);
        String message = this.labels.getString("propertyDialogCorpusFilename") + " " + this.currentCorpus.getName() + " (" + formatter.format(this.currentCorpus.length() / 1024L) + "KB)" + "\n";
        message = message + this.labels.getString("propertyDialogFileEncoding") + " " + this.concordance.getEncoding() + "\n";
        message = message + this.labels.getString("propertyDialogNumUniqueWords") + " " + this.concordance.getWordListSize() + "\n";
        message = message + this.labels.getString("propertyDialogNumWords") + " " + this.concordance.getWordIndexSize() + "\n";
        JOptionPane.showMessageDialog(this, message, this.labels.getString("fileMenuPropItem"), -1);
    }

    public void saveConcordance(File file, String outEncoding, int type) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), outEncoding));
        if (type == 0) {
            out.write(this.saveHTMLConcordanceTable());
        } else if (type == 1) {
            out.write(this.savePlainConcordanceText());
        }
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    public void saveFrequencyList(File file, String outEncoding, int type) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), outEncoding));
        if (type == 0) {
            out.write(this.saveHtmlWordFrequencyTable(outEncoding));
        } else if (type == 1) {
            out.write(this.savePlainWordFrequencyText());
        }
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    private void createWindowSizeDialog() {
        String s = JOptionPane.showInputDialog(this, this.labels.getString("windowSizeMessage"), this.labels.getString("windowSizeTitle"), -1);
        if (s != null && s.length() > 0) {
            Integer size = new Integer(s);
            this.concordance.setWindowSize(size);
            this.programProperties.setProperty("defaultWindowSize", size.toString());
            this.statusWinLabel.setText(this.labels.getString("statusbarContextSize") + new Integer(this.concordance.getWindowSize()).toString());
            if (this.currentWord.length() > 0) {
                this.getConcordance();
            }
        }
    }

    private void initConcordance(File filename, String enc) {
        this.concordance = new Concordance();
        try {
            this.currentCorpus = filename;
            this.concordance.setEncoding(enc);
            this.concordance.createWordIndex(filename);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private class DoConcordanceButton
    implements ActionListener {
        private DoConcordanceButton() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ConcordanceGUI.this.wordField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(ConcordanceGUI.this, ConcordanceGUI.this.labels.getString("noWordMessage"), ConcordanceGUI.this.labels.getString("noWordTitle"), 0);
            } else {
                BreakIterator wordIterator = BreakIterator.getWordInstance(ConcordanceGUI.this.currentLocale);
                wordIterator.setText(ConcordanceGUI.this.wordField.getText().trim());
                ConcordanceGUI.this.currentWord = ConcordanceGUI.this.wordField.getText().substring(wordIterator.first(), wordIterator.next());
                ConcordanceGUI.this.getConcordance();
            }
        }
    }
}

