/*
 * Decompiled with CFR 0.152.
 */
package aconcorde;

import aconcorde.ConcordanceItem;
import aconcorde.WordFreq;
import aconcorde.WordIndexWithPunc;
import aconcorde.WordWithPunctuation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Pattern;

public class Concordance {
    protected List wordList;
    protected List wordIndex;
    protected int numberOfWords = 0;
    private int windowSize = 5;
    protected Locale currentLocale;
    static final int LEFT_TO_RIGHT = 1;
    static final int RIGHT_TO_LEFT = 2;
    private int textOrientation;
    protected String encoding = "UTF8";

    public Concordance() {
        this.currentLocale = Locale.getDefault();
        this.textOrientation = 1;
    }

    public Concordance(Locale cLocale) {
        this.currentLocale = cLocale;
        this.textOrientation = 1;
    }

    private List extractWords(String target) {
        BreakIterator wordIterator = BreakIterator.getWordInstance(this.currentLocale);
        Vector<String> words = new Vector<String>();
        wordIterator.setText(target);
        int start = wordIterator.first();
        int end = wordIterator.next();
        while (end != -1) {
            String word = target.substring(start, end);
            if (Character.isLetterOrDigit(word.charAt(0))) {
                words.add(word);
            }
            start = end;
            end = wordIterator.next();
        }
        return words;
    }

    public List extractWordsWithPunctuation(String target) {
        target = target.replaceAll("$", " ");
        BreakIterator wordIterator = BreakIterator.getWordInstance(Locale.getDefault());
        boolean foundPunc = false;
        boolean foundNextWord = false;
        String leftPunc = "";
        String rightPunc = "";
        String currentWord = "";
        Vector<WordWithPunctuation> words = new Vector<WordWithPunctuation>();
        wordIterator.setText(target);
        int start = wordIterator.first();
        int end = wordIterator.next();
        while (end != -1) {
            String word = target.substring(start, end);
            if (Character.isLetterOrDigit(word.charAt(0))) {
                if (!foundNextWord) {
                    foundNextWord = true;
                    foundPunc = true;
                    currentWord = word;
                } else {
                    words.add(new WordWithPunctuation(leftPunc, currentWord, rightPunc));
                    rightPunc = "";
                    leftPunc = "";
                    currentWord = word;
                }
            } else if (!foundPunc) {
                leftPunc = leftPunc + word;
            } else {
                rightPunc = rightPunc + word;
            }
            start = end;
            end = wordIterator.next();
        }
        if (currentWord != null && !currentWord.equals("")) {
            words.add(new WordWithPunctuation(leftPunc, currentWord, rightPunc));
        }
        return words;
    }

    public void createWordList(String inFilename) throws IOException {
        this.createWordList(new File(inFilename));
    }

    public void createWordList(File inFile) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), this.encoding));
        this.wordList = new Vector();
        boolean stopReading = false;
        while (!stopReading) {
            String buffer = in.readLine();
            if (buffer != null) {
                List words = new Vector();
                words = this.extractWords(buffer);
                Iterator i = words.iterator();
                while (i.hasNext()) {
                    WordFreq wf = new WordFreq((String)i.next());
                    int index = Collections.binarySearch(this.wordList, wf);
                    if (index < 0) {
                        this.wordList.add((index + 1) * -1, wf);
                        continue;
                    }
                    ((WordFreq)this.wordList.get(index)).incrementCount();
                }
                this.numberOfWords += words.size();
                continue;
            }
            stopReading = true;
        }
        in.close();
    }

    public String displayWordList() {
        Iterator words = this.wordList.iterator();
        String output = "";
        String newline = System.getProperty("line.separator");
        while (words.hasNext()) {
            System.out.println(((WordFreq)words.next()).getWord());
        }
        return output;
    }

    public ListIterator getWordListIterator() {
        return this.wordList.listIterator();
    }

    public int getWordListSize() {
        return this.wordList.size();
    }

    public void displayWordIndex() {
        Iterator words = this.wordIndex.iterator();
        while (words.hasNext()) {
            System.out.println(words.next());
        }
    }

    public ListIterator getWordIndexIterator() {
        return this.wordIndex.listIterator();
    }

    public int getWordIndexSize() {
        return this.wordIndex.size();
    }

    public void createWordIndex(String inFilename) throws IOException {
        this.createWordList(new File(inFilename));
        this.createWordIndex(new File(inFilename));
    }

    public void createWordIndex(File inFile) throws IOException {
        this.createWordList(inFile);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), this.encoding));
        this.wordIndex = new Vector(this.numberOfWords);
        boolean stopReading = false;
        int lineCount = 1;
        while (!stopReading) {
            String buffer = in.readLine();
            if (buffer != null) {
                if (!Pattern.matches("^\\s*$", buffer)) {
                    List words = new Vector();
                    words = this.extractWordsWithPunctuation(buffer);
                    for (WordWithPunctuation wwp : words) {
                        WordFreq wf = new WordFreq(wwp.getWord());
                        this.wordIndex.add(new WordIndexWithPunc(Collections.binarySearch(this.wordList, wf), wwp.getLeftPunctuation(), wwp.getRightPunctuation()));
                    }
                }
            } else {
                stopReading = true;
            }
            ++lineCount;
        }
        in.close();
    }

    public String getWord(int wordPosition) {
        WordIndexWithPunc wwp = (WordIndexWithPunc)this.wordIndex.get(wordPosition);
        int index = wwp.getIndex();
        String word = wwp.getLeftPunctuation() + ((WordFreq)this.wordList.get(index)).getWord() + wwp.getRightPunctuation();
        return word;
    }

    public Vector getWordIndex(String word) {
        WordFreq wf = new WordFreq(word);
        int thisWordIndex = Collections.binarySearch(this.wordList, wf);
        Vector<Integer> indexes = new Vector<Integer>();
        ListIterator li = this.wordIndex.listIterator();
        while (li.hasNext()) {
            int indexPos = li.nextIndex();
            int currentIndex = ((WordIndexWithPunc)li.next()).getIndex();
            if (currentIndex != thisWordIndex) continue;
            indexes.add(new Integer(indexPos));
        }
        return indexes;
    }

    public String getSequenceOfWords(int beginPosition, int endPosition) throws IllegalArgumentException {
        if (endPosition < beginPosition) {
            throw new IllegalArgumentException("beginPosition must be less than endPosition.");
        }
        String sequence = new String();
        for (int i = beginPosition; i < endPosition; ++i) {
            sequence = sequence + this.getWord(i);
        }
        return sequence;
    }

    public void setWindowSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Error: concordance window size must be greater than 0!");
        }
        this.windowSize = size;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private String reverseWords(String input) {
        String rWords = "";
        List words = new Vector();
        words = this.extractWords(input);
        ListIterator reIt = words.listIterator(words.size());
        while (reIt.hasPrevious()) {
            rWords = rWords + reIt.previous();
            if (!reIt.hasPrevious()) continue;
            rWords = rWords + " ";
        }
        return rWords;
    }

    public void setOrientation(int oValue) throws IllegalArgumentException {
        if (oValue != 1 && oValue != 2) {
            throw new IllegalArgumentException("Orientation: " + oValue + ". Orientation value must be either 1 (LTR) or 2 (RTL).");
        }
        this.textOrientation = oValue;
    }

    public int getOrientation() {
        return this.textOrientation;
    }

    public String concordance(String word) throws IllegalArgumentException {
        String newline = System.getProperty("line.separator");
        int window = this.getWindowSize();
        String output = "";
        Vector indexes = new Vector(this.getWordIndex(word));
        if (indexes.size() == 0) {
            throw new IllegalArgumentException("The word \"" + word + "\" does not appear in this text.");
        }
        ListIterator li = indexes.listIterator();
        while (li.hasNext()) {
            Integer currentIndex;
            if (this.getOrientation() == 1) {
                currentIndex = (Integer)li.next();
                output = currentIndex - window < 0 ? output + "[START] " + this.getSequenceOfWords(0, currentIndex) : output + this.getSequenceOfWords(currentIndex - window, currentIndex);
                output = output + " *" + word + "*  ";
                output = currentIndex + window > this.wordIndex.size() - 1 ? output + this.getSequenceOfWords(currentIndex + 1, this.wordIndex.size()) + " [END]" : output + this.getSequenceOfWords(currentIndex + 1, currentIndex + (1 + window));
                output = output + newline;
                continue;
            }
            currentIndex = (Integer)li.next();
            output = currentIndex + window > this.wordIndex.size() - 1 ? output + "[END] " + this.reverseWords(this.getSequenceOfWords(currentIndex + 1, this.wordIndex.size())) : output + this.reverseWords(this.getSequenceOfWords(currentIndex + 1, currentIndex + (1 + window)));
            output = output + " *" + word + "*  ";
            output = currentIndex - window < 0 ? output + this.reverseWords(this.getSequenceOfWords(0, currentIndex)) + " [START]" : output + this.reverseWords(this.getSequenceOfWords(currentIndex - window, currentIndex));
            output = output + newline;
        }
        return output;
    }

    public List concordanceToList(String word) throws IllegalArgumentException {
        Vector<ConcordanceItem> items = new Vector<ConcordanceItem>();
        String leftContext = "";
        String rightContext = "";
        int window = this.getWindowSize();
        String output = "";
        Vector indexes = new Vector(this.getWordIndex(word));
        if (indexes.size() == 0) {
            throw new IllegalArgumentException("The word \"" + word + "\" does not appear in this text.");
        }
        ListIterator li = indexes.listIterator();
        while (li.hasNext()) {
            Integer currentIndex;
            if (this.getOrientation() == 1) {
                currentIndex = (Integer)li.next();
                leftContext = currentIndex - window < 0 ? "[START] " + this.getSequenceOfWords(0, currentIndex) : this.getSequenceOfWords(currentIndex - window, currentIndex);
                rightContext = currentIndex + window > this.wordIndex.size() - 1 ? this.getSequenceOfWords(currentIndex + 1, this.wordIndex.size()) + " [END]" : this.getSequenceOfWords(currentIndex + 1, currentIndex + (1 + window));
                items.add(new ConcordanceItem(leftContext, word, rightContext));
                continue;
            }
            currentIndex = (Integer)li.next();
            leftContext = currentIndex + window > this.wordIndex.size() - 1 ? "[END] " + this.reverseWords(this.getSequenceOfWords(currentIndex + 1, this.wordIndex.size())) : this.reverseWords(this.getSequenceOfWords(currentIndex + 1, currentIndex + (1 + window)));
            rightContext = currentIndex - window < 0 ? this.reverseWords(this.getSequenceOfWords(0, currentIndex)) + " [START]" : this.reverseWords(this.getSequenceOfWords(currentIndex - window, currentIndex));
            items.add(new ConcordanceItem(leftContext, word, rightContext));
        }
        return items;
    }
}

