/*
 * Decompiled with CFR 0.152.
 */
package aconcorde;

import aconcorde.ConcordanceGUI;
import aconcorde.MDIDesktopPane;
import aconcorde.WindowMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class Aconcorde
extends MDIDesktopPane {
    private static JFrame frame;
    private Aconcorde acc;
    final JFileChooser fc = new JFileChooser();
    private File currentDirectory;
    private File sourceFile;
    private File targetFile;
    private JDialog fontDialog;
    private JSpinner fontSpinner;
    private JTextField sourceFilenameField;
    private JTextField targetFilenameField;
    private JComboBox encodingOptions;
    private JComboBox sourceEncodingOptions;
    private JComboBox targetEncodingOptions;
    private Font menuFont;
    private Font textFont;
    private Font componentFont;
    private ResourceBundle labels;
    private Locale currentLocale;
    private ComponentOrientation co;
    private String[] encOptions = new String[]{"ASCII", "Cp420", "Cp1256", "ISO8859_6", "MacArabic", "UTF8", "UTF-16"};
    private String defaultEncoding = "UTF8";
    private String programName = "aConCorde";
    private String versionNum = "0.4.3";
    private String developer = "Andrew Roberts";
    private Properties programProperties;
    private int propDefaultWindowSize;

    public Aconcorde() {
        this.loadResources();
        this.co = ComponentOrientation.getOrientation(this.currentLocale);
        this.menuFont = new Font("Lucida Sans", 1, 12);
        this.textFont = new Font("Lucida Sans", 0, 12);
        this.componentFont = new Font("Lucida Sans", 1, 12);
        this.currentDirectory = new File(".");
        this.addEncodingAccessory();
    }

    private void addEncodingAccessory() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.ipadx = 2;
        c.ipady = 2;
        JPanel saveOptionsPanel = new JPanel(gridbag);
        saveOptionsPanel.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new TitledBorder(this.labels.getString("saveDialogOptions"))), new EmptyBorder(5, 5, 5, 5)));
        JLabel saveEncLabel = new JLabel(this.labels.getString("saveDialogSaveEnc"));
        this.encodingOptions = new JComboBox<String>(this.encOptions);
        this.encodingOptions.setSelectedItem(this.defaultEncoding);
        c.gridwidth = 1;
        gridbag.setConstraints(saveEncLabel, c);
        saveOptionsPanel.add(saveEncLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this.encodingOptions, c);
        saveOptionsPanel.add(this.encodingOptions);
        this.fc.setAccessory(saveOptionsPanel);
    }

    private static void applyComponentOrientation(Component c, ComponentOrientation o) {
        block3: {
            block2: {
                c.setComponentOrientation(o);
                if (!(c instanceof JMenu)) break block2;
                JMenu menu = (JMenu)c;
                int nComponents = menu.getMenuComponentCount();
                for (int i = 0; i < nComponents; ++i) {
                    Aconcorde.applyComponentOrientation(menu.getMenuComponent(i), o);
                }
                break block3;
            }
            if (!(c instanceof Container)) break block3;
            Container container = (Container)c;
            int nComponents = container.getComponentCount();
            for (int i = 0; i < nComponents; ++i) {
                Aconcorde.applyComponentOrientation(container.getComponent(i), o);
            }
        }
    }

    private static void applyFontSize(Component c, Font f) {
        block4: {
            block6: {
                block5: {
                    block3: {
                        if (!(c instanceof ConcordanceGUI)) break block3;
                        ((ConcordanceGUI)c).applyFontSize(c, f);
                        break block4;
                    }
                    c.setFont(f);
                    if (!(c instanceof WindowMenu)) break block5;
                    System.out.println(c instanceof JMenu);
                    JMenu menu = (JMenu)c;
                    int nComponents = menu.getMenuComponentCount();
                    System.out.println(nComponents);
                    for (int i = 0; i < nComponents; ++i) {
                        Aconcorde.applyFontSize(menu.getMenuComponent(i), f);
                    }
                    break block4;
                }
                if (!(c instanceof JMenu)) break block6;
                JMenu menu = (JMenu)c;
                int nComponents = menu.getMenuComponentCount();
                for (int i = 0; i < nComponents; ++i) {
                    Aconcorde.applyFontSize(menu.getMenuComponent(i), f);
                }
                break block4;
            }
            if (!(c instanceof Container)) break block4;
            Container container = (Container)c;
            int nComponents = container.getComponentCount();
            for (int i = 0; i < nComponents; ++i) {
                Aconcorde.applyFontSize(container.getComponent(i), f);
            }
        }
    }

    private static void applyCompFontSize(Component c, Font f) {
        if (!(c instanceof JMenu) && !(c instanceof JMenuItem)) {
            if (c instanceof JLabel) {
                c.setFont(f);
            } else if (c instanceof JButton) {
                c.setFont(f);
            } else if (c instanceof JTextField) {
                c.setFont(f);
            } else if (c instanceof JComboBox) {
                c.setFont(f);
            } else if (c instanceof Container) {
                Container container = (Container)c;
                int nComponents = container.getComponentCount();
                for (int i = 0; i < nComponents; ++i) {
                    Aconcorde.applyCompFontSize(container.getComponent(i), f);
                }
            }
        }
    }

    public Font getFontSize() {
        return this.menuFont;
    }

    private void loadResources() {
        try {
            this.currentLocale = Locale.getDefault();
            this.labels = ResourceBundle.getBundle("aconcorde.LabelsBundle", this.currentLocale);
            this.programProperties = new Properties();
            InputStream in = this.getClass().getResourceAsStream("/aconcorde/Aconcorde.properties");
            this.programProperties.load(in);
            this.propDefaultWindowSize = Integer.parseInt(this.programProperties.getProperty("defaultWindowSize", "5"));
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Malformed Unicode in Aconcorde.properties. Ignoring file and using inbuilt defaults instead...");
            iae.printStackTrace(System.err);
            this.propDefaultWindowSize = 5;
        }
        catch (IOException ioe) {
            System.err.println("Aconcorde.properties file missing. Using inbuilt defaults instead...");
            ioe.printStackTrace(System.err);
            this.propDefaultWindowSize = 5;
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private JMenuBar createMenus() {
        Font fLucida = new Font("Lucida Sans", 1, 10);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(this.labels.getString("fileMenu"));
        JMenu settingsMenu = new JMenu(this.labels.getString("settingsMenu"));
        JMenu viewMenu = new JMenu(this.labels.getString("viewMenu"));
        JMenu helpMenu = new JMenu(this.labels.getString("helpMenu"));
        JMenuItem openItem = new JMenuItem(this.labels.getString("fileMenuOpenItem"));
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Aconcorde.this.createFileOpenDialog();
            }
        });
        JMenuItem exitItem = new JMenuItem(this.labels.getString("fileMenuExitItem"));
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Aconcorde.this.shutdown();
            }
        });
        fileMenu.add(openItem);
        fileMenu.add(exitItem);
        JMenuItem fontItem = new JMenuItem(this.labels.getString("settingsMenuFontItem"));
        fontItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Aconcorde.this.createFontSizeDialog();
            }
        });
        LocaleChanger langMenu = new LocaleChanger();
        settingsMenu.add(fontItem);
        settingsMenu.add(langMenu);
        JMenuItem contentsItem = new JMenuItem(this.labels.getString("helpMenuContentsItem"));
        contentsItem.setEnabled(false);
        JMenuItem aboutItem = new JMenuItem(this.labels.getString("helpMenuAboutItem"));
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Aconcorde.this.createAboutDialog();
            }
        });
        helpMenu.add(contentsItem);
        helpMenu.add(aboutItem);
        menuBar.add(fileMenu);
        menuBar.add(settingsMenu);
        menuBar.add(new WindowMenu(this));
        menuBar.add(helpMenu);
        return menuBar;
    }

    private void createFileOpenDialog() {
        this.fc.setCurrentDirectory(this.currentDirectory);
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            File corpus = this.fc.getSelectedFile();
            if ((String)this.encodingOptions.getSelectedItem() != null) {
                ConcordanceGUI conc = new ConcordanceGUI(corpus, (String)this.encodingOptions.getSelectedItem(), this.propDefaultWindowSize, this.menuFont, this.programProperties);
                conc.setSize(800, 600);
                this.add(conc);
                conc.setVisible(true);
                this.currentDirectory = corpus;
            }
        }
    }

    private void showBrowseFileDialog(int index) {
        this.fc.setCurrentDirectory(this.currentDirectory);
        if (index == 0) {
            this.encodingOptions.setSelectedIndex(this.sourceEncodingOptions.getSelectedIndex());
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                this.sourceFile = this.fc.getSelectedFile();
                this.sourceFilenameField.setText(this.sourceFile.getName());
                this.sourceEncodingOptions.setSelectedIndex(this.encodingOptions.getSelectedIndex());
                this.currentDirectory = this.fc.getCurrentDirectory();
            }
        } else if (index == 1) {
            this.encodingOptions.setSelectedIndex(this.sourceEncodingOptions.getSelectedIndex());
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                this.targetFile = this.fc.getSelectedFile();
                this.targetFilenameField.setText(this.targetFile.getName());
                this.targetEncodingOptions.setSelectedIndex(this.encodingOptions.getSelectedIndex());
                this.currentDirectory = this.fc.getCurrentDirectory();
            }
        }
    }

    private void createFontSizeDialog() {
        this.fontDialog = new JDialog(frame, this.labels.getString("fontSizeTitle"), true);
        Container contents = this.fontDialog.getContentPane();
        contents.setLayout(new BorderLayout());
        JPanel fontSettings = new JPanel();
        JPanel buttonsPanel = new JPanel();
        int min = 8;
        int max = 72;
        int step = 1;
        this.fontSpinner = new JSpinner(new SpinnerNumberModel(this.menuFont.getSize(), min, max, step));
        fontSettings.setLayout(new GridLayout(1, 2));
        fontSettings.add(new JLabel(this.labels.getString("fontSize")));
        fontSettings.add(this.fontSpinner);
        JButton fontSizeOk = new JButton(this.labels.getString("fontSizeOk"));
        fontSizeOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int menuSize;
                int textSize;
                int compSize = textSize = (menuSize = ((Integer)Aconcorde.this.fontSpinner.getValue()).intValue());
                Aconcorde.this.menuFont = new Font(Aconcorde.this.menuFont.getName(), Aconcorde.this.menuFont.getStyle(), menuSize);
                Aconcorde.this.textFont = new Font(Aconcorde.this.textFont.getName(), Aconcorde.this.textFont.getStyle(), textSize);
                Aconcorde.this.componentFont = new Font(Aconcorde.this.componentFont.getName(), Aconcorde.this.componentFont.getStyle(), compSize);
                Aconcorde.applyFontSize(frame, Aconcorde.this.menuFont);
                Aconcorde.this.fontDialog.setVisible(false);
            }
        });
        JButton fontSizeCancel = new JButton(this.labels.getString("fontSizeCancel"));
        fontSizeCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Aconcorde.this.fontDialog.setVisible(false);
            }
        });
        buttonsPanel.add(fontSizeOk);
        buttonsPanel.add(fontSizeCancel);
        contents.add((Component)fontSettings, "Center");
        contents.add((Component)buttonsPanel, "South");
        this.fontDialog.setLocationRelativeTo(this);
        this.fontDialog.pack();
        this.fontDialog.setVisible(true);
    }

    private void createAboutDialog() {
        String message = this.programName + "\n";
        message = message + "Version " + this.versionNum + "\n\n";
        message = message + this.labels.getString("aboutDeveloped") + " " + this.developer + "\n";
        message = message + "School of Computing\n";
        message = message + "University of Leeds\n";
        message = message + "Leeds\n";
        message = message + "United Kingdom\n\n";
        message = message + this.labels.getString("aboutAck") + ":\n";
        message = message + this.labels.getString("aboutArabicTranslation") + " - Latifa Al-Sulaiti,\nBayan Abu Shawar &\nSaleh Al-Osaimi";
        JOptionPane.showMessageDialog(this, message, this.labels.getString("helpMenuAboutItem"), -1);
    }

    private void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        frame = new JFrame(this.programName + " - " + this.versionNum);
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                Aconcorde.this.shutdown();
            }
        };
        frame.addWindowListener(windowListener);
        frame.setDefaultCloseOperation(0);
        this.acc = new Aconcorde();
        frame.getContentPane().add(this.acc);
        frame.setJMenuBar(this.acc.createMenus());
        Aconcorde.applyComponentOrientation(frame, this.co);
        frame.pack();
        frame.setSize(1024, 768);
        frame.setVisible(true);
    }

    private void shutdown() {
        frame.dispose();
        try {
            this.programProperties.store(new FileOutputStream("aConCorde.properties"), new Date().toString());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Aconcorde gui = new Aconcorde();
                gui.createAndShowGUI();
            }
        });
    }

    class LocaleChanger
    extends JMenu
    implements ItemListener {
        public LocaleChanger() {
            this.setText(Aconcorde.this.labels.getString("settingsMenuLanguageItem"));
            ButtonGroup langGroup = new ButtonGroup();
            String language = Locale.getDefault().getLanguage();
            RuleBasedCollator rbc = (RuleBasedCollator)Collator.getInstance();
            ArrayList<String> al = new ArrayList<String>();
            al.add(Aconcorde.this.labels.getString("settingsMenuLanguageArabicItem"));
            al.add(Aconcorde.this.labels.getString("settingsMenuLanguageEnglishItem"));
            Collections.sort(al, rbc);
            String langName = Locale.getDefault().getDisplayLanguage();
            for (int i = 0; i < al.size(); ++i) {
                JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem((String)al.get(i)));
                if (langName.equalsIgnoreCase((String)al.get(i))) {
                    mi.setSelected(true);
                }
                mi.addItemListener(this);
                langGroup.add(mi);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
                if (rb.isSelected()) {
                    String selected = rb.getText();
                    if (selected.equals(Aconcorde.this.labels.getString("settingsMenuLanguageArabicItem"))) {
                        Locale.setDefault(new Locale("ar", "EG"));
                        Aconcorde.this.co = ComponentOrientation.RIGHT_TO_LEFT;
                    } else if (selected.equals(Aconcorde.this.labels.getString("settingsMenuLanguageEnglishItem"))) {
                        Locale.setDefault(Locale.UK);
                        Aconcorde.this.co = ComponentOrientation.LEFT_TO_RIGHT;
                    }
                }
                if (Aconcorde.this.co != null) {
                    Aconcorde ac = new Aconcorde();
                    frame.getContentPane().removeAll();
                    frame.setJMenuBar(ac.createMenus());
                    frame.setContentPane(ac);
                    Aconcorde.applyComponentOrientation(frame, Aconcorde.this.co);
                    frame.repaint();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }
}

